/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.module.chirper.configuration.provider;

import java.nio.file.Path;
import me.whereareiam.socialismus.api.Reloadable;
import me.whereareiam.socialismus.api.input.registry.Registry;
import me.whereareiam.socialismus.api.output.DefaultConfig;
import me.whereareiam.socialismus.api.output.config.ConfigurationLoader;
import me.whereareiam.socialismus.api.output.config.ConfigurationManager;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Provider;
import me.whereareiam.socialismus.library.guice.Singleton;
import me.whereareiam.socialismus.library.guice.name.Named;
import me.whereareiam.socialismus.module.chirper.api.model.config.ChirperMessages;
import me.whereareiam.socialismus.module.chirper.configuration.template.ChirperMessagesTemplate;

@Singleton
public class ChirperMessagesProvider
implements Provider<ChirperMessages>,
Reloadable {
    private final Path workingPath;
    private final ConfigurationLoader configLoader;
    private ChirperMessages messages;

    @Inject
    public ChirperMessagesProvider(@Named(value="workingPath") Path workingPath, ConfigurationLoader configLoader, ConfigurationManager configManager, ChirperMessagesTemplate template, Registry<Reloadable> registry) {
        this.workingPath = workingPath;
        this.configLoader = configLoader;
        configManager.addTemplate(ChirperMessages.class, (DefaultConfig)template);
        registry.register((Object)this);
        this.get();
    }

    public ChirperMessages get() {
        if (this.messages != null) {
            return this.messages;
        }
        this.load();
        return this.messages;
    }

    public void reload() {
        this.load();
    }

    private void load() {
        this.messages = (ChirperMessages)this.configLoader.load(this.workingPath.resolve("messages"), ChirperMessages.class);
    }
}

