/*
 * Decompiled with CFR 0.152.
 */
package carbonchat.libs.com.seiama.event.registry;

import carbonchat.libs.com.seiama.event.EventConfig;
import carbonchat.libs.com.seiama.event.EventSubscriber;
import carbonchat.libs.com.seiama.event.EventSubscription;
import carbonchat.libs.com.seiama.event.registry.EventRegistry;
import carbonchat.libs.com.seiama.event.registry.Internals;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.Predicate;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class SimpleEventRegistry<E>
implements EventRegistry<E> {
    private static final Comparator<EventSubscription<?>> ORDER_COMPARATOR = Comparator.comparingInt(subscription -> subscription.config().order());
    private final Map<Class<? extends E>, Collection<? extends Class<?>>> classes = new HashMap();
    private final Map<Class<? extends E>, List<EventSubscription<? super E>>> unbaked = new HashMap<Class<? extends E>, List<EventSubscription<? super E>>>();
    private final Map<Class<? extends E>, List<EventSubscription<? super E>>> baked = new HashMap<Class<? extends E>, List<EventSubscription<? super E>>>();
    private final Object lock = new Object();
    private final Class<E> type;

    public SimpleEventRegistry(Class<E> type) {
        this.type = Objects.requireNonNull(type, "type");
    }

    @Override
    public Class<E> type() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends E> EventSubscription<T> subscribe(Class<T> event, EventConfig config, EventSubscriber<? super T> subscriber) {
        Objects.requireNonNull(event, "event");
        Objects.requireNonNull(config, "config");
        Objects.requireNonNull(subscriber, "subscriber");
        EventSubscriptionImpl<? super T> subscription = new EventSubscriptionImpl<T>(event, config, subscriber);
        Object object = this.lock;
        synchronized (object) {
            List subscriptions = SimpleEventRegistry.yayGenerics(this.unbaked.computeIfAbsent(event, key -> new ArrayList()));
            subscriptions.add(subscription);
            this.baked.clear();
        }
        return subscription;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unsubscribeIf(Predicate<EventSubscription<? super E>> predicate) {
        Object object = this.lock;
        synchronized (object) {
            boolean removedAny = false;
            for (List<EventSubscription<EventSubscription<? super E>>> list : this.unbaked.values()) {
                removedAny |= list.removeIf(predicate);
            }
            if (removedAny) {
                this.baked.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<EventSubscription<? super E>> subscriptions(Class<? extends E> event) {
        Object object = this.lock;
        synchronized (object) {
            return this.baked.computeIfAbsent(event, this::computeSubscriptions);
        }
    }

    private List<EventSubscription<? super E>> computeSubscriptions(Class<? extends E> event) {
        ArrayList subscriptions = new ArrayList();
        Collection types = this.classes.computeIfAbsent(event, this::findClasses);
        for (Class type : types) {
            subscriptions.addAll(this.unbaked.getOrDefault(type, Collections.emptyList()));
        }
        subscriptions.sort(ORDER_COMPARATOR);
        return subscriptions;
    }

    private Collection<? extends Class<?>> findClasses(Class<?> type) {
        List<Class<?>> classes = Internals.ancestors(type);
        classes.removeIf(klass -> !this.type.isAssignableFrom((Class<?>)klass));
        return classes;
    }

    private static <T extends U, U> List<U> yayGenerics(List<T> list) {
        return list;
    }

    private class EventSubscriptionImpl<T extends E>
    implements EventSubscription<T> {
        private final Class<T> event;
        private final EventConfig config;
        private final EventSubscriber<? super T> subscriber;

        EventSubscriptionImpl(Class<T> event, EventConfig config, EventSubscriber<? super T> subscriber) {
            this.event = event;
            this.config = config;
            this.subscriber = subscriber;
        }

        @Override
        public Class<T> event() {
            return this.event;
        }

        @Override
        public EventConfig config() {
            return this.config;
        }

        @Override
        public EventSubscriber<? super T> subscriber() {
            return this.subscriber;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispose() {
            Object object = SimpleEventRegistry.this.lock;
            synchronized (object) {
                @Nullable List<U> subscriptions = SimpleEventRegistry.yayGenerics(SimpleEventRegistry.this.unbaked.get(this.event));
                if (subscriptions != null) {
                    subscriptions.remove(this);
                    SimpleEventRegistry.this.baked.clear();
                }
            }
        }

        public String toString() {
            return new StringJoiner(", ", this.getClass().getSimpleName() + "[", "]").add("event=" + String.valueOf(this.event)).add("config=" + String.valueOf(this.config)).add("subscriber=" + String.valueOf(this.subscriber)).toString();
        }
    }
}

