/*
 * Decompiled with CFR 0.152.
 */
package carbonchat.libs.com.seiama.registry;

import carbonchat.libs.com.seiama.registry.Holder;
import carbonchat.libs.com.seiama.registry.Holders;
import carbonchat.libs.com.seiama.registry.Registry;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
final class RegistryImpl<K, V>
implements Registry<K, V> {
    private final Map<K, Holder<K, V>> keyToHolder = new HashMap<K, Holder<K, V>>();
    private @Nullable Set<K> keys;

    RegistryImpl() {
    }

    @Override
    public @Nullable Holder<K, V> getHolder(K key) {
        Objects.requireNonNull(key, "key");
        return this.keyToHolder.get(key);
    }

    @Override
    public Holder<K, V> getOrCreateHolder(K key) {
        Objects.requireNonNull(key, "key");
        @Nullable Holder<K, V> holder = this.keyToHolder.get(key);
        if (holder == null) {
            holder = new Holders.Lazy(key);
            this.keyToHolder.put(key, holder);
        }
        return holder;
    }

    @Override
    public Holder<K, V> register(K key, V value) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(value, "value");
        @Nullable Holder<K, V> holder = this.keyToHolder.get(key);
        if (holder == null) {
            holder = new Holders.Immediate<K, V>(key, value);
            this.keyToHolder.put(key, holder);
        } else {
            IllegalStateException alreadyBound;
            V oldValue = null;
            if (holder instanceof Holders.Immediate) {
                Holders.Immediate immediate = (Holders.Immediate)holder;
                oldValue = immediate.value();
            } else if (holder instanceof Holders.Lazy) {
                Holders.Lazy lazy = (Holders.Lazy)holder;
                oldValue = lazy.bind(value);
            }
            if (oldValue != null && (alreadyBound = RegistryImpl.alreadyBound(key, oldValue, value)) != null) {
                throw alreadyBound;
            }
        }
        return holder;
    }

    @Override
    public Set<K> keys() {
        if (this.keys == null) {
            this.keys = Collections.unmodifiableSet(this.keyToHolder.keySet());
        }
        return this.keys;
    }

    @VisibleForTesting
    static <K, V> @Nullable IllegalStateException alreadyBound(K key, V oldValue, V newValue) {
        if (oldValue != newValue) {
            return new IllegalStateException(String.valueOf(key) + " is already bound to " + String.valueOf(oldValue) + ", cannot bind to " + String.valueOf(newValue));
        }
        return null;
    }
}

