/*
 * Decompiled with CFR 0.152.
 */
package carbonchat.libs.net.kyori.adventure.serializer.configurate4;

import carbonchat.libs.net.kyori.adventure.serializer.configurate4.BlockNBTPosSerializer;
import carbonchat.libs.net.kyori.adventure.serializer.configurate4.KeySerializer;
import carbonchat.libs.org.spongepowered.configurate.ConfigurationNode;
import carbonchat.libs.org.spongepowered.configurate.serialize.SerializationException;
import carbonchat.libs.org.spongepowered.configurate.serialize.TypeSerializer;
import io.leangen.geantyref.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.BlockNBTComponent;
import net.kyori.adventure.text.BuildableComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentBuilder;
import net.kyori.adventure.text.EntityNBTComponent;
import net.kyori.adventure.text.KeybindComponent;
import net.kyori.adventure.text.NBTComponent;
import net.kyori.adventure.text.NBTComponentBuilder;
import net.kyori.adventure.text.ScoreComponent;
import net.kyori.adventure.text.SelectorComponent;
import net.kyori.adventure.text.StorageNBTComponent;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.TranslationArgument;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.serializer.ComponentSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ComponentTypeSerializer
implements TypeSerializer<Component> {
    static final TypeToken<List<Component>> LIST_TYPE = new TypeToken<List<Component>>(){};
    static final String TEXT = "text";
    static final String TRANSLATE = "translate";
    static final String TRANSLATE_WITH = "with";
    static final String TRANSLATE_FALLBACK = "fallback";
    static final String SCORE = "score";
    static final String SCORE_NAME = "name";
    static final String SCORE_OBJECTIVE = "objective";
    static final String SCORE_VALUE = "value";
    static final String SELECTOR = "selector";
    static final String KEYBIND = "keybind";
    static final String EXTRA = "extra";
    static final String NBT = "nbt";
    static final String NBT_INTERPRET = "interpret";
    static final String NBT_BLOCK = "block";
    static final String NBT_ENTITY = "entity";
    static final String NBT_STORAGE = "storage";
    @Nullable
    private final ComponentSerializer<Component, ? extends Component, String> stringSerial;
    private final boolean preferString;

    ComponentTypeSerializer(@Nullable ComponentSerializer<Component, ? extends Component, String> stringSerial, boolean preferString) {
        this.stringSerial = stringSerial;
        this.preferString = preferString;
    }

    @Override
    @NotNull
    public Component deserialize(@NotNull Type type, @NotNull ConfigurationNode value) throws SerializationException {
        return this.deserialize0(value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    private BuildableComponent<?, ?> deserialize0(@NotNull ConfigurationNode value) throws SerializationException {
        Style style;
        TextComponent.Builder component;
        Map<Object, ? extends ConfigurationNode> children;
        if (!value.isList() && !value.isMap()) {
            String str = value.getString();
            if (str != null) {
                if (this.stringSerial == null) return Component.text((String)str);
                Component ret = this.stringSerial.deserialize((Object)str);
                if (ret instanceof BuildableComponent) return (BuildableComponent)ret;
                throw new SerializationException("Result " + ret + " is not builable");
            }
        } else {
            if (value.isList()) {
                ComponentBuilder parent = null;
                for (ConfigurationNode configurationNode : value.childrenList()) {
                    BuildableComponent<?, ?> child = this.deserialize0(configurationNode);
                    if (parent == null) {
                        parent = child.toBuilder();
                        continue;
                    }
                    parent.append(child);
                }
                if (parent != null) return parent.build();
                throw ComponentTypeSerializer.notSureHowToDeserialize(value);
            }
            if (!value.isMap()) {
                throw ComponentTypeSerializer.notSureHowToDeserialize(value);
            }
        }
        if ((children = value.childrenMap()).containsKey(TEXT)) {
            component = Component.text().content(children.get(TEXT).getString());
        } else if (children.containsKey(TRANSLATE)) {
            TranslatableComponent.Builder builder = Component.translatable().key(children.get(TRANSLATE).getString());
            if (children.containsKey(TRANSLATE_WITH)) {
                ConfigurationNode with = children.get(TRANSLATE_WITH);
                if (!with.isList()) {
                    throw new SerializationException("Expected with to be a list");
                }
                List<TranslationArgument> list = with.getList(TranslationArgument.class);
                builder.arguments(list);
            }
            if (children.containsKey(TRANSLATE_FALLBACK)) {
                builder.fallback(children.get(TRANSLATE_FALLBACK).getString());
            }
            component = builder;
        } else if (children.containsKey(SCORE)) {
            ConfigurationNode configurationNode = children.get(SCORE);
            ConfigurationNode name = configurationNode.node(SCORE_NAME);
            ConfigurationNode configurationNode2 = configurationNode.node(SCORE_OBJECTIVE);
            if (name.virtual() || configurationNode2.virtual()) {
                throw new SerializationException("A score component requires a name and objective");
            }
            ScoreComponent.Builder builder = Component.score().name(name.getString()).objective(configurationNode2.getString());
            ConfigurationNode scoreValue = configurationNode.node(SCORE_VALUE);
            component = !scoreValue.virtual() ? builder.value(scoreValue.getString()) : builder;
        } else if (children.containsKey(SELECTOR)) {
            component = Component.selector().pattern(children.get(SELECTOR).getString());
        } else if (children.containsKey(KEYBIND)) {
            component = Component.keybind().keybind(children.get(KEYBIND).getString());
        } else {
            boolean interpret;
            if (!children.containsKey(NBT)) throw ComponentTypeSerializer.notSureHowToDeserialize(value);
            String string = children.get(NBT).getString();
            boolean bl = interpret = children.containsKey(NBT_INTERPRET) && children.get(NBT_INTERPRET).getBoolean();
            if (children.containsKey(NBT_BLOCK)) {
                BlockNBTComponent.Pos pos = (BlockNBTComponent.Pos)children.get(NBT_BLOCK).get(BlockNBTPosSerializer.INSTANCE.type());
                component = ComponentTypeSerializer.nbt(Component.blockNBT(), string, interpret).pos(pos);
            } else if (children.containsKey(NBT_ENTITY)) {
                component = ComponentTypeSerializer.nbt(Component.entityNBT(), string, interpret).selector(children.get(NBT_ENTITY).getString());
            } else {
                if (!children.containsKey(NBT_STORAGE)) throw ComponentTypeSerializer.notSureHowToDeserialize(value);
                component = ComponentTypeSerializer.nbt(Component.storageNBT(), string, interpret).storage((Key)children.get(NBT_STORAGE).get(KeySerializer.INSTANCE.type()));
            }
        }
        if (children.containsKey(EXTRA)) {
            ConfigurationNode configurationNode = children.get(EXTRA);
            for (ConfigurationNode configurationNode3 : configurationNode.childrenList()) {
                component.append(this.deserialize0(configurationNode3));
            }
        }
        if ((style = value.get(Style.class, Style.empty())).isEmpty()) return component.build();
        component.style(style);
        return component.build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void serialize(@NotNull Type type, @Nullable Component src, @NotNull ConfigurationNode value) throws SerializationException {
        value.set(null);
        if (src == null) {
            return;
        }
        if (this.stringSerial != null && this.preferString) {
            try {
                value.set(this.stringSerial.serialize(src));
                return;
            }
            catch (Exception ex) {
                throw new SerializationException(ex);
            }
        }
        if (src instanceof TextComponent) {
            value.node(TEXT).set(((TextComponent)src).content());
        } else if (src instanceof TranslatableComponent) {
            TranslatableComponent tc = (TranslatableComponent)src;
            value.node(TRANSLATE).set(tc.key());
            if (!tc.arguments().isEmpty()) {
                ConfigurationNode with = value.node(TRANSLATE_WITH);
                for (TranslationArgument arg : tc.arguments()) {
                    with.appendListNode().set(TranslationArgument.class, arg);
                }
            }
            value.node(TRANSLATE_FALLBACK).set(tc.fallback());
        } else if (src instanceof ScoreComponent) {
            ScoreComponent sc = (ScoreComponent)src;
            ConfigurationNode score = value.node(SCORE);
            score.node(SCORE_NAME).set(sc.name());
            score.node(SCORE_OBJECTIVE).set(sc.objective());
            @Nullable String scoreValue = sc.value();
            if (scoreValue != null) {
                score.node(SCORE_VALUE).set(scoreValue);
            }
        } else if (src instanceof SelectorComponent) {
            value.node(SELECTOR).set(((SelectorComponent)src).pattern());
        } else if (src instanceof KeybindComponent) {
            value.node(KEYBIND).set(((KeybindComponent)src).keybind());
        } else {
            if (!(src instanceof NBTComponent)) throw ComponentTypeSerializer.notSureHowToSerialize(src);
            NBTComponent nc = (NBTComponent)src;
            value.node(NBT).set(nc.nbtPath());
            value.node(NBT_INTERPRET).set(nc.interpret());
            if (src instanceof BlockNBTComponent) {
                value.node(NBT_BLOCK).set(BlockNBTPosSerializer.INSTANCE.type(), ((BlockNBTComponent)nc).pos());
            } else if (src instanceof EntityNBTComponent) {
                value.node(NBT_ENTITY).set(((EntityNBTComponent)nc).selector());
            } else {
                if (!(src instanceof StorageNBTComponent)) throw ComponentTypeSerializer.notSureHowToSerialize(src);
                value.node(NBT_STORAGE).set(KeySerializer.INSTANCE.type(), ((StorageNBTComponent)nc).storage());
            }
        }
        List children = src.children();
        if (!children.isEmpty()) {
            value.node(EXTRA).set(LIST_TYPE, children);
        }
        if (!src.hasStyling()) return;
        value.set(Style.class, src.style());
    }

    private static <C extends NBTComponent<C, B>, B extends NBTComponentBuilder<C, B>> B nbt(B builder, String nbt, boolean interpret) {
        return (B)builder.nbtPath(nbt).interpret(interpret);
    }

    private static SerializationException notSureHowToDeserialize(ConfigurationNode element) {
        return new SerializationException("Don't know how to turn " + element + " into a Component");
    }

    private static SerializationException notSureHowToSerialize(Component component) {
        return new SerializationException("Don't know how to serialize " + component + " as a Component");
    }
}

