/*
 * Decompiled with CFR 0.152.
 */
package carbonchat.libs.net.kyori.adventure.serializer.configurate4;

import carbonchat.libs.net.kyori.adventure.serializer.configurate4.BlockNBTPosSerializer;
import carbonchat.libs.net.kyori.adventure.serializer.configurate4.BookTypeSerializer;
import carbonchat.libs.net.kyori.adventure.serializer.configurate4.ComponentTypeSerializer;
import carbonchat.libs.net.kyori.adventure.serializer.configurate4.ConfigurateComponentSerializer;
import carbonchat.libs.net.kyori.adventure.serializer.configurate4.ConfigurateDataComponentValue;
import carbonchat.libs.net.kyori.adventure.serializer.configurate4.ConfigurateDataComponentValueTypeSerializer;
import carbonchat.libs.net.kyori.adventure.serializer.configurate4.DurationSerializer;
import carbonchat.libs.net.kyori.adventure.serializer.configurate4.HoverEventShowEntitySerializer;
import carbonchat.libs.net.kyori.adventure.serializer.configurate4.HoverEventShowItemSerializer;
import carbonchat.libs.net.kyori.adventure.serializer.configurate4.IndexSerializer;
import carbonchat.libs.net.kyori.adventure.serializer.configurate4.KeySerializer;
import carbonchat.libs.net.kyori.adventure.serializer.configurate4.ShadowColorSerializer;
import carbonchat.libs.net.kyori.adventure.serializer.configurate4.SoundSerializer;
import carbonchat.libs.net.kyori.adventure.serializer.configurate4.SoundStopSerializer;
import carbonchat.libs.net.kyori.adventure.serializer.configurate4.StyleSerializer;
import carbonchat.libs.net.kyori.adventure.serializer.configurate4.TextColorSerializer;
import carbonchat.libs.net.kyori.adventure.serializer.configurate4.TitleSerializer;
import carbonchat.libs.net.kyori.adventure.serializer.configurate4.TranslationArgumentTypeSerializer;
import carbonchat.libs.org.spongepowered.configurate.BasicConfigurationNode;
import carbonchat.libs.org.spongepowered.configurate.ConfigurationNode;
import carbonchat.libs.org.spongepowered.configurate.ConfigurationOptions;
import carbonchat.libs.org.spongepowered.configurate.serialize.SerializationException;
import carbonchat.libs.org.spongepowered.configurate.serialize.TypeSerializerCollection;
import carbonchat.libs.org.spongepowered.configurate.util.UnmodifiableCollections;
import io.leangen.geantyref.TypeToken;
import java.util.Objects;
import net.kyori.adventure.inventory.Book;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.sound.SoundStop;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TranslationArgument;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.format.ShadowColor;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.ComponentSerializer;
import net.kyori.adventure.title.Title;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ConfigurateComponentSerializerImpl
implements ConfigurateComponentSerializer {
    static final ConfigurateComponentSerializer INSTANCE = new Builder().build();
    private final TypeSerializerCollection serializers;
    private final ConfigurationOptions ownNodeOptions;
    @Nullable
    private final ComponentSerializer<Component, ?, String> stringSerializer;
    private final boolean serializeStringComponents;

    private ConfigurateComponentSerializerImpl(@NotNull Builder builder) {
        this.stringSerializer = builder.stringSerializer;
        this.serializeStringComponents = builder.outputStringComponents;
        this.serializers = this.makeSerializers(TypeSerializerCollection.defaults().childBuilder());
        this.ownNodeOptions = ConfigurationOptions.defaults().serializers(this.serializers).nativeTypes(UnmodifiableCollections.toSet(String.class, Integer.class, Boolean.class, Double.class, Float.class));
    }

    @NotNull
    public Component deserialize(@NotNull ConfigurationNode input) {
        try {
            @Nullable Component deserialized = input.get(Component.class);
            if (deserialized != null) {
                return deserialized;
            }
        }
        catch (SerializationException e) {
            throw new IllegalArgumentException(e);
        }
        throw new IllegalArgumentException("No value present");
    }

    @NotNull
    public ConfigurationNode serialize(@NotNull Component component) {
        BasicConfigurationNode base = BasicConfigurationNode.root(this.ownNodeOptions);
        try {
            base.set(Component.class, component);
        }
        catch (SerializationException e) {
            throw new IllegalStateException("Unable to serialize component " + component, e);
        }
        return base;
    }

    @NotNull
    private TypeSerializerCollection makeSerializers(@NotNull TypeSerializerCollection.Builder serializers) {
        return serializers.register(Book.class, BookTypeSerializer.INSTANCE).register(Title.class, TitleSerializer.INSTANCE).register(Sound.class, SoundSerializer.INSTANCE).register(SoundStop.class, SoundStopSerializer.INSTANCE).register(Component.class, new ComponentTypeSerializer(this.stringSerializer, this.serializeStringComponents)).register(KeySerializer.INSTANCE).register(DurationSerializer.INSTANCE).register(Style.class, StyleSerializer.INSTANCE).register(TextColorSerializer.INSTANCE).register(BlockNBTPosSerializer.INSTANCE).register(TranslationArgument.class, TranslationArgumentTypeSerializer.INSTANCE).registerExact(new IndexSerializer(TypeToken.get(ClickEvent.Action.class), ClickEvent.Action.NAMES)).registerExact(new IndexSerializer(new TypeToken<HoverEvent.Action<?>>(){}, HoverEvent.Action.NAMES)).registerExact(new IndexSerializer(TypeToken.get(Sound.Source.class), Sound.Source.NAMES)).registerExact(new IndexSerializer(TypeToken.get(TextDecoration.class), TextDecoration.NAMES)).registerExact(HoverEvent.ShowEntity.class, HoverEventShowEntitySerializer.INSTANCE).registerExact(HoverEvent.ShowItem.class, HoverEventShowItemSerializer.INSTANCE).register(ConfigurateDataComponentValue.class, ConfigurateDataComponentValueTypeSerializer.INSTANCE).register(ShadowColor.class, ShadowColorSerializer.INSTACE).build();
    }

    @Override
    @NotNull
    public TypeSerializerCollection serializers() {
        return this.serializers;
    }

    static class Builder
    implements ConfigurateComponentSerializer.Builder {
        @Nullable
        private ComponentSerializer<Component, ?, String> stringSerializer;
        private boolean outputStringComponents = false;

        Builder() {
        }

        @Override
        public @NotNull ConfigurateComponentSerializer.Builder scalarSerializer(@NotNull ComponentSerializer<Component, ?, String> stringSerializer) {
            this.stringSerializer = Objects.requireNonNull(stringSerializer, "stringSerializer");
            return this;
        }

        @Override
        public @NotNull ConfigurateComponentSerializer.Builder outputStringComponents(boolean stringComponents) {
            this.outputStringComponents = stringComponents;
            return this;
        }

        @Override
        @NotNull
        public ConfigurateComponentSerializer build() {
            return new ConfigurateComponentSerializerImpl(this);
        }
    }
}

