/*
 * Decompiled with CFR 0.152.
 */
package carbonchat.libs.net.kyori.adventure.serializer.configurate4;

import carbonchat.libs.org.spongepowered.configurate.ConfigurationNode;
import carbonchat.libs.org.spongepowered.configurate.serialize.SerializationException;
import carbonchat.libs.org.spongepowered.configurate.serialize.TypeSerializer;
import java.lang.reflect.Type;
import java.util.UUID;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.HoverEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class HoverEventShowEntitySerializer
implements TypeSerializer<HoverEvent.ShowEntity> {
    static final HoverEventShowEntitySerializer INSTANCE = new HoverEventShowEntitySerializer();
    static final String ENTITY_TYPE = "type";
    static final String ID = "id";
    static final String NAME = "name";

    private HoverEventShowEntitySerializer() {
    }

    @Override
    public HoverEvent.ShowEntity deserialize(@NotNull Type type, @NotNull ConfigurationNode value) throws SerializationException {
        Key typeId = value.node(ENTITY_TYPE).get(Key.class);
        UUID id = value.node(ID).get(UUID.class);
        if (typeId == null || id == null) {
            throw new SerializationException("A show entity hover event needs type and id fields to be deserialized");
        }
        @Nullable Component name = value.node(NAME).get(Component.class);
        return HoverEvent.ShowEntity.showEntity((Key)typeId, (UUID)id, (Component)name);
    }

    @Override
    public void serialize(@NotNull Type type, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable HoverEvent.ShowEntity obj, @NotNull ConfigurationNode value) throws SerializationException {
        if (obj == null) {
            value.set(null);
            return;
        }
        value.node(ENTITY_TYPE).set(Key.class, obj.type());
        value.node(ID).set(UUID.class, obj.id());
        value.node(NAME).set(Component.class, obj.name());
    }
}

