/*
 * Decompiled with CFR 0.152.
 */
package carbonchat.libs.net.kyori.adventure.serializer.configurate4;

import carbonchat.libs.net.kyori.adventure.serializer.configurate4.ConfigurateDataComponentValue;
import carbonchat.libs.org.spongepowered.configurate.ConfigurationNode;
import carbonchat.libs.org.spongepowered.configurate.serialize.SerializationException;
import carbonchat.libs.org.spongepowered.configurate.serialize.TypeSerializer;
import io.leangen.geantyref.TypeToken;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.Keyed;
import net.kyori.adventure.nbt.api.BinaryTagHolder;
import net.kyori.adventure.text.event.HoverEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class HoverEventShowItemSerializer
implements TypeSerializer<HoverEvent.ShowItem> {
    static final HoverEventShowItemSerializer INSTANCE = new HoverEventShowItemSerializer();
    private static final TypeToken<Map<Key, ConfigurateDataComponentValue>> COMPONENT_MAP_TYPE = new TypeToken<Map<Key, ConfigurateDataComponentValue>>(){};
    static final String ID = "id";
    static final String COUNT = "count";
    static final String TAG = "tag";
    static final String COMPONENTS = "components";

    private HoverEventShowItemSerializer() {
    }

    @Override
    public HoverEvent.ShowItem deserialize(@NotNull Type type, @NotNull ConfigurationNode value) throws SerializationException {
        Key id = value.node(ID).get(Key.class);
        if (id == null) {
            throw new SerializationException("An id is required to deserialize the show_item hover event");
        }
        int count = value.node(COUNT).getInt(1);
        ConfigurationNode components = value.node(COMPONENTS);
        if (!components.virtual()) {
            Map<Key, ConfigurateDataComponentValue> componentsMap = components.require(COMPONENT_MAP_TYPE);
            return HoverEvent.ShowItem.showItem((Keyed)id, (int)count, new HashMap<Key, ConfigurateDataComponentValue>(componentsMap));
        }
        String tag = value.node(TAG).getString();
        return HoverEvent.ShowItem.showItem((Key)id, (int)count, (BinaryTagHolder)(tag == null ? null : BinaryTagHolder.binaryTagHolder((String)tag)));
    }

    @Override
    public void serialize(@NotNull Type type, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable HoverEvent.ShowItem obj, @NotNull ConfigurationNode value) throws SerializationException {
        if (obj == null) {
            value.set(null);
            return;
        }
        value.node(ID).set(Key.class, obj.item());
        value.node(COUNT).set(obj.count());
        if (!obj.dataComponents().isEmpty()) {
            value.node(TAG).set(null);
            value.node(COMPONENTS).set(COMPONENT_MAP_TYPE, obj.dataComponentsAs(ConfigurateDataComponentValue.class));
        } else if (obj.nbt() != null) {
            value.node(COMPONENTS).set(null);
            value.node(TAG).set(obj.nbt().string());
        } else {
            value.node(COMPONENTS).set(null);
        }
    }
}

