/*
 * Decompiled with CFR 0.152.
 */
package carbonchat.libs.net.kyori.adventure.serializer.configurate4;

import carbonchat.libs.org.spongepowered.configurate.ConfigurationNode;
import carbonchat.libs.org.spongepowered.configurate.serialize.SerializationException;
import carbonchat.libs.org.spongepowered.configurate.serialize.TypeSerializer;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class TitleSerializer
implements TypeSerializer<Title> {
    static final TitleSerializer INSTANCE = new TitleSerializer();
    static final Duration KEEP = Duration.ofSeconds(-1L);
    static final String TITLE = "title";
    static final String SUBTITLE = "subtitle";
    static final String TIMES = "times";
    static final String FADE_IN = "fade-in";
    static final String STAY = "stay";
    static final String FADE_OUT = "fade-out";

    private TitleSerializer() {
    }

    @Override
    @Nullable
    public Title deserialize(@NotNull Type type, @NotNull ConfigurationNode value) throws SerializationException {
        if (value.empty()) {
            return null;
        }
        Component title = (Component)value.node(TITLE).get(Component.class, Component.empty());
        Component subtitle = (Component)value.node(SUBTITLE).get(Component.class, Component.empty());
        Duration fadeIn = value.node(TIMES, FADE_IN).get(Duration.class, KEEP);
        Duration stay = value.node(TIMES, STAY).get(Duration.class, KEEP);
        Duration fadeOut = value.node(TIMES, FADE_OUT).get(Duration.class, KEEP);
        if (!(Objects.equals(fadeIn, KEEP) && Objects.equals(stay, KEEP) && Objects.equals(fadeOut, KEEP))) {
            return Title.title((Component)title, (Component)subtitle, (Title.Times)Title.Times.times((Duration)fadeIn, (Duration)stay, (Duration)fadeOut));
        }
        return Title.title((Component)title, (Component)subtitle);
    }

    @Override
    public void serialize(@NotNull Type type, @Nullable Title obj, @NotNull ConfigurationNode value) throws SerializationException {
        if (obj == null) {
            value.set(null);
            return;
        }
        value.node(TITLE).set(Component.class, obj.title());
        value.node(SUBTITLE).set(Component.class, obj.subtitle());
        // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable Title.Times times = obj.times();
        value.node(TIMES, FADE_IN).set(Duration.class, times == null || times == Title.DEFAULT_TIMES ? null : times.fadeIn());
        value.node(TIMES, STAY).set(Duration.class, times == null || times == Title.DEFAULT_TIMES ? null : times.stay());
        value.node(TIMES, FADE_OUT).set(Duration.class, times == null || times == Title.DEFAULT_TIMES ? null : times.fadeOut());
    }
}

