/*
 * Decompiled with CFR 0.152.
 */
package carbonchat.libs.net.kyori.adventure.serializer.configurate4;

import carbonchat.libs.org.checkerframework.checker.nullness.qual.Nullable;
import carbonchat.libs.org.spongepowered.configurate.ConfigurationNode;
import carbonchat.libs.org.spongepowered.configurate.serialize.SerializationException;
import carbonchat.libs.org.spongepowered.configurate.serialize.TypeSerializer;
import java.lang.reflect.Type;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TranslationArgument;

final class TranslationArgumentTypeSerializer
implements TypeSerializer<TranslationArgument> {
    static final TranslationArgumentTypeSerializer INSTANCE = new TranslationArgumentTypeSerializer();

    private TranslationArgumentTypeSerializer() {
    }

    @Override
    public TranslationArgument deserialize(Type type, ConfigurationNode node) throws SerializationException {
        Object raw = node.rawScalar();
        if (raw instanceof Boolean) {
            return TranslationArgument.bool((boolean)((Boolean)raw));
        }
        if (raw instanceof Number) {
            return TranslationArgument.numeric((Number)((Number)raw));
        }
        return TranslationArgument.component((ComponentLike)((ComponentLike)node.require(Component.class)));
    }

    @Override
    public void serialize(Type type, @Nullable TranslationArgument obj, ConfigurationNode node) throws SerializationException {
        if (obj == null) {
            node.set(null);
            return;
        }
        Object value = obj.value();
        if (value instanceof Boolean || value instanceof Number) {
            node.set(value);
        } else if (value instanceof Component) {
            node.set((Type)((Object)Component.class), value);
        } else {
            throw new SerializationException(node, type, "Unknown translation arg value of type " + value.getClass() + ": " + value);
        }
    }
}

