/*
 * Decompiled with CFR 0.152.
 */
package carbonchat.libs.net.kyori.moonshine;

import carbonchat.libs.net.kyori.moonshine.MoonshineBuilder;
import carbonchat.libs.net.kyori.moonshine.MoonshineInvocationHandler;
import carbonchat.libs.net.kyori.moonshine.exception.MissingMoonshineMethodMappingException;
import carbonchat.libs.net.kyori.moonshine.exception.scan.UnscannableMethodException;
import carbonchat.libs.net.kyori.moonshine.message.IMessageRenderer;
import carbonchat.libs.net.kyori.moonshine.message.IMessageSender;
import carbonchat.libs.net.kyori.moonshine.message.IMessageSource;
import carbonchat.libs.net.kyori.moonshine.model.MoonshineMethod;
import carbonchat.libs.net.kyori.moonshine.placeholder.IPlaceholderResolver;
import carbonchat.libs.net.kyori.moonshine.receiver.IReceiverLocatorResolver;
import carbonchat.libs.net.kyori.moonshine.strategy.IPlaceholderResolverStrategy;
import carbonchat.libs.net.kyori.moonshine.util.Weighted;
import carbonchat.libs.org.checkerframework.dataflow.qual.Pure;
import carbonchat.libs.org.checkerframework.dataflow.qual.SideEffectFree;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.geantyref.TypeToken;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableSet;

public final class Moonshine<R, I, O, F> {
    private final TypeToken<?> proxiedType;
    private final MoonshineInvocationHandler<R, I, O, F> invocationHandler;
    private final IPlaceholderResolverStrategy<R, I, F> placeholderResolverStrategy;
    private final IMessageSource<R, I> messageSource;
    private final IMessageRenderer<R, I, O, F> messageRenderer;
    private final IMessageSender<R, O> messageSender;
    private final NavigableSet<Weighted<? extends IReceiverLocatorResolver<? extends R>>> weightedReceiverLocatorResolvers;
    private final Map<Type, NavigableSet<Weighted<? extends IPlaceholderResolver<? extends R, ?, ? extends F>>>> weightedPlaceholderResolvers;
    private final Map<Method, MoonshineMethod<? extends R>> scannedMethods;

    Moonshine(TypeToken<?> proxiedType, IPlaceholderResolverStrategy<R, I, F> placeholderResolverStrategy, IMessageSource<R, I> messageSource, IMessageRenderer<R, I, O, F> messageRenderer, IMessageSender<R, O> messageSender, NavigableSet<Weighted<? extends IReceiverLocatorResolver<? extends R>>> weightedReceiverLocatorResolvers, Map<Type, NavigableSet<Weighted<? extends IPlaceholderResolver<? extends R, ?, ? extends F>>>> weightedPlaceholderResolvers) throws UnscannableMethodException {
        this.proxiedType = proxiedType;
        this.placeholderResolverStrategy = placeholderResolverStrategy;
        this.messageSource = messageSource;
        this.messageRenderer = messageRenderer;
        this.messageSender = messageSender;
        this.weightedReceiverLocatorResolvers = Collections.unmodifiableNavigableSet(weightedReceiverLocatorResolvers);
        this.weightedPlaceholderResolvers = Collections.unmodifiableMap(weightedPlaceholderResolvers);
        Method[] methods = GenericTypeReflector.erase((Type)proxiedType.getType()).getMethods();
        HashMap scannedMethods = new HashMap(methods.length);
        for (Method method : methods) {
            if (method.isDefault() || method.getReturnType() == Moonshine.class) continue;
            MoonshineMethod moonshineMethod = new MoonshineMethod(this, proxiedType, method);
            scannedMethods.put(method, moonshineMethod);
        }
        this.scannedMethods = Collections.unmodifiableMap(scannedMethods);
        this.invocationHandler = new MoonshineInvocationHandler(this);
    }

    @SideEffectFree
    public static <T, R> MoonshineBuilder.Receivers<T, R> builder(TypeToken<T> proxiedType) {
        return MoonshineBuilder.newBuilder(proxiedType);
    }

    @Pure
    public Type proxiedType() {
        return this.proxiedType.getType();
    }

    @Pure
    public MoonshineInvocationHandler<R, I, O, F> invocationHandler() {
        return this.invocationHandler;
    }

    @Pure
    public IPlaceholderResolverStrategy<R, I, F> placeholderResolverStrategy() {
        return this.placeholderResolverStrategy;
    }

    @Pure
    public NavigableSet<Weighted<? extends IReceiverLocatorResolver<? extends R>>> weightedReceiverLocatorResolvers() {
        return this.weightedReceiverLocatorResolvers;
    }

    @Pure
    public Map<Type, NavigableSet<Weighted<? extends IPlaceholderResolver<? extends R, ?, ? extends F>>>> weightedPlaceholderResolvers() {
        return this.weightedPlaceholderResolvers;
    }

    public MoonshineMethod<? extends R> scannedMethod(Method method) throws MissingMoonshineMethodMappingException {
        MoonshineMethod<? extends R> scanned = this.scannedMethods.get(method);
        if (scanned == null) {
            throw new MissingMoonshineMethodMappingException(this.proxiedType(), method);
        }
        return scanned;
    }

    public IMessageSource<R, I> messageSource() {
        return this.messageSource;
    }

    public IMessageRenderer<R, I, O, F> messageRenderer() {
        return this.messageRenderer;
    }

    public IMessageSender<R, O> messageSender() {
        return this.messageSender;
    }
}

