/*
 * Decompiled with CFR 0.152.
 */
package carbonchat.libs.net.kyori.moonshine;

import carbonchat.libs.net.kyori.moonshine.Moonshine;
import carbonchat.libs.net.kyori.moonshine.exception.scan.UnscannableMethodException;
import carbonchat.libs.net.kyori.moonshine.message.IMessageRenderer;
import carbonchat.libs.net.kyori.moonshine.message.IMessageSender;
import carbonchat.libs.net.kyori.moonshine.message.IMessageSource;
import carbonchat.libs.net.kyori.moonshine.placeholder.IPlaceholderResolver;
import carbonchat.libs.net.kyori.moonshine.receiver.IReceiverLocatorResolver;
import carbonchat.libs.net.kyori.moonshine.strategy.IPlaceholderResolverStrategy;
import carbonchat.libs.net.kyori.moonshine.util.Weighted;
import carbonchat.libs.org.checkerframework.common.returnsreceiver.qual.This;
import carbonchat.libs.org.checkerframework.dataflow.qual.Deterministic;
import carbonchat.libs.org.checkerframework.dataflow.qual.Pure;
import carbonchat.libs.org.checkerframework.dataflow.qual.SideEffectFree;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.geantyref.TypeToken;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeSet;

public final class MoonshineBuilder {
    private MoonshineBuilder() {
    }

    @SideEffectFree
    static <T, R> Receivers<T, R> newBuilder(TypeToken<T> proxiedType) {
        return new Receivers(proxiedType);
    }

    public static final class Receivers<T, R> {
        private final NavigableSet<Weighted<? extends IReceiverLocatorResolver<? extends R>>> weightedReceiverLocatorResolvers = new TreeSet<Weighted<? extends IReceiverLocatorResolver<? extends R>>>();
        private final TypeToken<T> proxiedType;

        private Receivers(TypeToken<T> proxiedType) {
            this.proxiedType = proxiedType;
        }

        @Pure
        public NavigableSet<Weighted<? extends IReceiverLocatorResolver<? extends R>>> weightedReceiverLocatorResolvers() {
            return this.weightedReceiverLocatorResolvers;
        }

        @Deterministic
        public @This Receivers<T, R> receiverLocatorResolver(Weighted<? extends IReceiverLocatorResolver<? extends R>> weightedReceiverLocatorResolver) {
            this.weightedReceiverLocatorResolvers.add(weightedReceiverLocatorResolver);
            return this;
        }

        @Deterministic
        public @This Receivers<T, R> receiverLocatorResolver(IReceiverLocatorResolver<? extends R> receiverLocatorResolver, int weight) {
            this.weightedReceiverLocatorResolvers.add(new Weighted<IReceiverLocatorResolver<? extends R>>(receiverLocatorResolver, weight));
            return this;
        }

        @SideEffectFree
        public <I> Sourced<T, R, I> sourced(IMessageSource<R, I> messageSource) {
            return new Sourced<T, R, I>(this.proxiedType, this.weightedReceiverLocatorResolvers, messageSource);
        }
    }

    public static final class Resolved<T, R, I, O, F> {
        private final TypeToken<T> proxiedType;
        private final NavigableSet<Weighted<? extends IReceiverLocatorResolver<? extends R>>> weightedReceiverLocatorResolvers;
        private final IMessageSource<R, I> messageSource;
        private final IMessageRenderer<R, I, O, F> messageRenderer;
        private final IMessageSender<R, O> messageSender;
        private final IPlaceholderResolverStrategy<R, I, F> placeholderResolverStrategy;
        private final Map<Type, NavigableSet<Weighted<? extends IPlaceholderResolver<? extends R, ?, ? extends F>>>> weightedPlaceholderResolvers = new HashMap();

        private Resolved(TypeToken<T> proxiedType, NavigableSet<Weighted<? extends IReceiverLocatorResolver<? extends R>>> weightedReceiverLocatorResolvers, IMessageSource<R, I> messageSource, IMessageRenderer<R, I, O, F> messageRenderer, IMessageSender<R, O> messageSender, IPlaceholderResolverStrategy<R, I, F> placeholderResolverStrategy) {
            this.proxiedType = proxiedType;
            this.weightedReceiverLocatorResolvers = weightedReceiverLocatorResolvers;
            this.messageSource = messageSource;
            this.messageRenderer = messageRenderer;
            this.messageSender = messageSender;
            this.placeholderResolverStrategy = placeholderResolverStrategy;
        }

        @Deterministic
        public <Z> @This Resolved<T, R, I, O, F> weightedPlaceholderResolver(Class<? extends Z> resolvedType, Weighted<? extends IPlaceholderResolver<? extends R, ? super Z, ? extends F>> weightedPlaceholderResolver) {
            this.weightedPlaceholderResolvers.computeIfAbsent(resolvedType, ignored -> new TreeSet()).add(weightedPlaceholderResolver);
            return this;
        }

        @Deterministic
        public <Z> @This Resolved<T, R, I, O, F> weightedPlaceholderResolver(TypeToken<? extends Z> resolvedType, Weighted<? extends IPlaceholderResolver<? extends R, ? super Z, ? extends F>> weightedPlaceholderResolver) {
            this.weightedPlaceholderResolvers.computeIfAbsent(resolvedType.getType(), ignored -> new TreeSet()).add(weightedPlaceholderResolver);
            return this;
        }

        @Deterministic
        public <Z> @This Resolved<T, R, I, O, F> weightedPlaceholderResolver(Class<? extends Z> resolvedType, IPlaceholderResolver<? extends R, ? super Z, ? extends F> placeholderResolver, int weight) {
            this.weightedPlaceholderResolvers.computeIfAbsent(resolvedType, ignored -> new TreeSet()).add(new Weighted<IPlaceholderResolver<? extends R, ? super Z, ? extends F>>(placeholderResolver, weight));
            return this;
        }

        @Deterministic
        public <Z> @This Resolved<T, R, I, O, F> weightedPlaceholderResolver(TypeToken<? extends Z> resolvedType, IPlaceholderResolver<? extends R, ? super Z, ? extends F> placeholderResolver, int weight) {
            this.weightedPlaceholderResolvers.computeIfAbsent(resolvedType.getType(), ignored -> new TreeSet()).add(new Weighted<IPlaceholderResolver<? extends R, ? super Z, ? extends F>>(placeholderResolver, weight));
            return this;
        }

        @SideEffectFree
        public T create() throws UnscannableMethodException {
            return this.create(Thread.currentThread().getContextClassLoader());
        }

        @SideEffectFree
        public T create(ClassLoader classLoader) throws UnscannableMethodException {
            Moonshine<R, I, O, F> moonshine = new Moonshine<R, I, O, F>(this.proxiedType, this.placeholderResolverStrategy, this.messageSource, this.messageRenderer, this.messageSender, this.weightedReceiverLocatorResolvers, this.weightedPlaceholderResolvers);
            return (T)Proxy.newProxyInstance(classLoader, new Class[]{GenericTypeReflector.erase((Type)this.proxiedType.getType())}, moonshine.invocationHandler());
        }
    }

    public static final class Sent<T, R, I, O, F> {
        private final TypeToken<T> proxiedType;
        private final NavigableSet<Weighted<? extends IReceiverLocatorResolver<? extends R>>> weightedReceiverLocatorResolvers;
        private final IMessageSource<R, I> messageSource;
        private final IMessageRenderer<R, I, O, F> messageRenderer;
        private final IMessageSender<R, O> messageSender;

        private Sent(TypeToken<T> proxiedType, NavigableSet<Weighted<? extends IReceiverLocatorResolver<? extends R>>> weightedReceiverLocatorResolvers, IMessageSource<R, I> messageSource, IMessageRenderer<R, I, O, F> messageRenderer, IMessageSender<R, O> messageSender) {
            this.proxiedType = proxiedType;
            this.weightedReceiverLocatorResolvers = weightedReceiverLocatorResolvers;
            this.messageSource = messageSource;
            this.messageRenderer = messageRenderer;
            this.messageSender = messageSender;
        }

        @SideEffectFree
        public Resolved<T, R, I, O, F> resolvingWithStrategy(IPlaceholderResolverStrategy<R, I, F> placeholderResolverStrategy) {
            return new Resolved<T, R, I, O, F>(this.proxiedType, this.weightedReceiverLocatorResolvers, this.messageSource, this.messageRenderer, this.messageSender, placeholderResolverStrategy);
        }
    }

    public static final class Rendered<T, R, I, O, F> {
        private final TypeToken<T> proxiedType;
        private final NavigableSet<Weighted<? extends IReceiverLocatorResolver<? extends R>>> weightedReceiverLocatorResolvers;
        private final IMessageSource<R, I> messageSource;
        private final IMessageRenderer<R, I, O, F> messageRenderer;

        private Rendered(TypeToken<T> proxiedType, NavigableSet<Weighted<? extends IReceiverLocatorResolver<? extends R>>> weightedReceiverLocatorResolvers, IMessageSource<R, I> messageSource, IMessageRenderer<R, I, O, F> messageRenderer) {
            this.proxiedType = proxiedType;
            this.weightedReceiverLocatorResolvers = weightedReceiverLocatorResolvers;
            this.messageSource = messageSource;
            this.messageRenderer = messageRenderer;
        }

        @SideEffectFree
        public Sent<T, R, I, O, F> sent(IMessageSender<R, O> messageSender) {
            return new Sent<T, R, I, O, F>(this.proxiedType, this.weightedReceiverLocatorResolvers, this.messageSource, this.messageRenderer, messageSender);
        }
    }

    public static final class Sourced<T, R, I> {
        private final TypeToken<T> proxiedType;
        private final NavigableSet<Weighted<? extends IReceiverLocatorResolver<? extends R>>> weightedReceiverLocatorResolvers;
        private final IMessageSource<R, I> messageSource;

        private Sourced(TypeToken<T> proxiedType, NavigableSet<Weighted<? extends IReceiverLocatorResolver<? extends R>>> weightedReceiverLocatorResolvers, IMessageSource<R, I> messageSource) {
            this.proxiedType = proxiedType;
            this.weightedReceiverLocatorResolvers = weightedReceiverLocatorResolvers;
            this.messageSource = messageSource;
        }

        @SideEffectFree
        public <O, F> Rendered<T, R, I, O, F> rendered(IMessageRenderer<R, I, O, F> messageRenderer) {
            return new Rendered<T, R, I, O, F>(this.proxiedType, this.weightedReceiverLocatorResolvers, this.messageSource, messageRenderer);
        }
    }
}

