/*
 * Decompiled with CFR 0.152.
 */
package carbonchat.libs.net.kyori.moonshine;

import carbonchat.libs.net.kyori.moonshine.Moonshine;
import carbonchat.libs.net.kyori.moonshine.internal.ReflectiveUtils;
import carbonchat.libs.net.kyori.moonshine.model.MoonshineMethod;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.Nullable;
import io.leangen.geantyref.GenericTypeReflector;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Map;

final class MoonshineInvocationHandler<R, I, O, F>
implements InvocationHandler {
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private final Moonshine<R, I, O, F> moonshine;

    MoonshineInvocationHandler(Moonshine<R, I, O, F> moonshine) {
        this.moonshine = moonshine;
    }

    @Override
    public @Nullable Object invoke(Object proxy, Method method, @Nullable Object @Nullable [] args) throws Throwable {
        if (MoonshineInvocationHandler.isEqualsMethod(method)) {
            return this.proxiedEquals(args);
        }
        if (MoonshineInvocationHandler.isHashCodeMethod(method)) {
            return this.moonshine.hashCode();
        }
        if (MoonshineInvocationHandler.isToStringMethod(method)) {
            return this.proxiedToString();
        }
        if (args == null) {
            args = EMPTY_OBJECT_ARRAY;
        }
        if (method.isDefault()) {
            MethodHandle handle = ReflectiveUtils.findMethod(method, proxy);
            if (args.length == 0) {
                return handle.invoke();
            }
            return handle.invokeWithArguments(args);
        }
        if (method.getReturnType() == Moonshine.class) {
            return this.moonshine;
        }
        MoonshineMethod<R> moonshineMethod = this.moonshine.scannedMethod(method);
        R receiver = moonshineMethod.receiverLocator().locate(method, proxy, args);
        I intermediateMessage = this.moonshine.messageSource().messageOf(receiver, moonshineMethod.messageKey());
        Map<String, F> resolvedPlaceholders = this.moonshine.placeholderResolverStrategy().resolvePlaceholders(this.moonshine, receiver, intermediateMessage, moonshineMethod, args);
        O renderedMessage = this.moonshine.messageRenderer().render(receiver, intermediateMessage, resolvedPlaceholders, method, this.moonshine.proxiedType());
        if (method.getReturnType() == Void.TYPE) {
            this.moonshine.messageSender().send(receiver, renderedMessage);
            return null;
        }
        return renderedMessage;
    }

    private boolean proxiedEquals(@Nullable Object @Nullable [] args) {
        if (args == null || args.length != 1) {
            return false;
        }
        return args[0] == this || args[0] == this.moonshine;
    }

    private String proxiedToString() {
        return GenericTypeReflector.getTypeName((Type)this.moonshine.proxiedType()) + "@" + this.moonshine.hashCode();
    }

    private static boolean isEqualsMethod(Method method) {
        return "equals".equals(method.getName()) && method.getParameterCount() == 1 && method.getReturnType() == Boolean.TYPE;
    }

    private static boolean isHashCodeMethod(Method method) {
        return "hashCode".equals(method.getName()) && method.getParameterCount() == 0 && method.getReturnType() == Integer.TYPE;
    }

    private static boolean isToStringMethod(Method method) {
        return "toString".equals(method.getName()) && method.getParameterCount() == 0 && method.getReturnType() == String.class;
    }
}

