/*
 * Decompiled with CFR 0.152.
 */
package carbonchat.libs.net.kyori.moonshine.model;

import carbonchat.libs.net.kyori.moonshine.Moonshine;
import carbonchat.libs.net.kyori.moonshine.annotation.Message;
import carbonchat.libs.net.kyori.moonshine.exception.scan.MissingMessageAnnotationException;
import carbonchat.libs.net.kyori.moonshine.exception.scan.NoReceiverLocatorFoundException;
import carbonchat.libs.net.kyori.moonshine.exception.scan.UnscannableMethodException;
import carbonchat.libs.net.kyori.moonshine.receiver.IReceiverLocator;
import carbonchat.libs.net.kyori.moonshine.receiver.IReceiverLocatorResolver;
import carbonchat.libs.net.kyori.moonshine.util.Weighted;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.Nullable;
import carbonchat.libs.org.checkerframework.dataflow.qual.Pure;
import io.leangen.geantyref.TypeToken;
import java.lang.reflect.Method;
import java.util.Iterator;

public final class MoonshineMethod<R> {
    private final TypeToken<?> owner;
    private final Method reflectMethod;
    private final String messageKey;
    private final IReceiverLocator<? extends R> receiverLocator;

    public MoonshineMethod(Moonshine<R, ?, ?, ?> moonshine, TypeToken<?> owner, Method reflectMethod) throws UnscannableMethodException {
        this.owner = owner;
        this.reflectMethod = reflectMethod;
        Message message = this.findMessageAnnotation();
        this.messageKey = message.value();
        this.receiverLocator = this.findReceiverLocator(moonshine);
    }

    @Pure
    public TypeToken<?> owner() {
        return this.owner;
    }

    @Pure
    public Method reflectMethod() {
        return this.reflectMethod;
    }

    @Pure
    public String messageKey() {
        return this.messageKey;
    }

    @Pure
    public IReceiverLocator<? extends R> receiverLocator() {
        return this.receiverLocator;
    }

    private Message findMessageAnnotation() throws MissingMessageAnnotationException {
        @Nullable Message annotation = this.reflectMethod.getAnnotation(Message.class);
        if (annotation == null) {
            throw new MissingMessageAnnotationException(this.owner.getType(), this.reflectMethod);
        }
        return annotation;
    }

    private IReceiverLocator<? extends R> findReceiverLocator(Moonshine<R, ?, ?, ?> moonshine) throws NoReceiverLocatorFoundException {
        Iterator<Weighted<IReceiverLocatorResolver<R>>> receiverLocatorResolverIterator = moonshine.weightedReceiverLocatorResolvers().descendingIterator();
        while (receiverLocatorResolverIterator.hasNext()) {
            IReceiverLocatorResolver<R> receiverLocatorResolver = receiverLocatorResolverIterator.next().value();
            @Nullable IReceiverLocator<R> resolvedLocator = receiverLocatorResolver.resolve(this.reflectMethod, this.owner.getType());
            if (resolvedLocator == null) continue;
            return resolvedLocator;
        }
        throw new NoReceiverLocatorFoundException(this.owner.getType(), this.reflectMethod);
    }
}

