/*
 * Decompiled with CFR 0.152.
 */
package carbonchat.libs.net.kyori.moonshine.util;

import carbonchat.libs.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.Nullable;
import carbonchat.libs.org.checkerframework.dataflow.qual.Pure;
import carbonchat.libs.org.checkerframework.dataflow.qual.SideEffectFree;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public final class Either<L, R> {
    private final @Nullable L left;
    private final @Nullable R right;

    private Either(@Nullable L left, @Nullable R right) {
        if (left == null == (right == null)) {
            throw new IllegalArgumentException("must be either left or right");
        }
        this.left = left;
        this.right = right;
    }

    @SideEffectFree
    public static <L, R> Either<L, R> left(L left) {
        return new Either<L, Object>(left, null);
    }

    @SideEffectFree
    public Optional<L> left() {
        return Optional.ofNullable(this.leftRaw());
    }

    @SideEffectFree
    public static <L, R> Either<L, R> right(R right) {
        return new Either<Object, R>(null, right);
    }

    @SideEffectFree
    public Optional<R> right() {
        return Optional.ofNullable(this.rightRaw());
    }

    @Pure
    public @Nullable L leftRaw() {
        return this.left;
    }

    @Pure
    public @Nullable R rightRaw() {
        return this.right;
    }

    @EnsuresNonNullIf(expression={"this.left"}, result=true)
    @Pure
    public boolean isLeft() {
        return this.left != null;
    }

    @EnsuresNonNullIf(expression={"this.right"}, result=true)
    @Pure
    public boolean isRight() {
        return this.right != null;
    }

    @Pure
    public void ifLeft(Consumer<L> leftConsumer) {
        if (this.leftRaw() != null) {
            leftConsumer.accept(this.leftRaw());
        }
    }

    @Pure
    public void ifRight(Consumer<R> rightConsumer) {
        if (this.rightRaw() != null) {
            rightConsumer.accept(this.rightRaw());
        }
    }

    @Pure
    public void map(Consumer<L> leftConsumer, Consumer<R> rightConsumer) {
        if (this.leftRaw() != null) {
            leftConsumer.accept(this.leftRaw());
        } else if (this.rightRaw() != null) {
            rightConsumer.accept(this.rightRaw());
        } else {
            throw new IllegalStateException("either left or right must be non-null");
        }
    }

    @Pure
    public boolean equals(@Nullable Object other) {
        if (!(other instanceof Either)) {
            return false;
        }
        Either otherEither = (Either)other;
        return Objects.equals(otherEither.leftRaw(), this.leftRaw()) && Objects.equals(otherEither.rightRaw(), this.rightRaw());
    }

    @Pure
    public int hashCode() {
        if (this.isLeft()) {
            return this.leftRaw().hashCode();
        }
        if (this.isRight()) {
            return this.rightRaw().hashCode();
        }
        throw new IllegalStateException("either left or right must be non-null");
    }

    public String toString() {
        return "Either{left=" + this.leftRaw() + ", right=" + this.rightRaw() + "}";
    }
}

