/*
 * Decompiled with CFR 0.152.
 */
package carbonchat.libs.ninja.egg82.messenger;

import carbonchat.libs.ninja.egg82.messenger.MessagingService;
import carbonchat.libs.ninja.egg82.messenger.handler.MessagingHandler;
import carbonchat.libs.ninja.egg82.messenger.packets.MultiPacket;
import carbonchat.libs.ninja.egg82.messenger.packets.Packet;
import carbonchat.libs.ninja.egg82.messenger.packets.server.InitializationPacket;
import carbonchat.libs.ninja.egg82.messenger.packets.server.PacketVersionPacket;
import carbonchat.libs.ninja.egg82.messenger.services.PacketService;
import carbonchat.libs.ninja.egg82.messenger.utils.MathUtil;
import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.ZstdException;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.util.LinkedHashSet;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMessagingService
implements MessagingService {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected static final ByteBufAllocator alloc = PooledByteBufAllocator.DEFAULT;
    protected final PacketService packetService;
    protected final String name;
    protected UUID serverId;
    protected String serverIdString;
    protected byte[] serverIdBytes;
    protected MessagingHandler handler;
    protected final boolean dumpPackets;
    protected final File sentPacketDirectory;
    protected final File receivedPacketDirectory;
    protected final long startupDelay;
    private static final double TOLERANCE = 1.1;
    private final int[] capacities = new int[150];
    private final AtomicInteger currentCapacity = new AtomicInteger(0);
    private volatile int capacity = 2048;
    private final ReadWriteLock capacityLock = new ReentrantReadWriteLock();
    protected final AtomicLong currentSendPacket = new AtomicLong(0L);
    protected final AtomicLong currentReceivePacket = new AtomicLong(0L);

    protected AbstractMessagingService(@NotNull PacketService packetService, @NotNull String name, long startupDelay, boolean dumpPackets, @NotNull File packetDirectory) {
        this.packetService = packetService;
        this.name = name;
        this.dumpPackets = dumpPackets;
        this.sentPacketDirectory = new File(packetDirectory, "sent");
        this.receivedPacketDirectory = new File(packetDirectory, "received");
        this.startupDelay = startupDelay;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final byte @NotNull [] compressData(@Nullable ByteBuf data) throws IOException {
        if (data == null || data.capacity() == 0) {
            return new byte[0];
        }
        data.readerIndex(0);
        int uncompressedBytes = data.writerIndex();
        int upperBound = (int)Zstd.compressBound((long)uncompressedBytes) + 5;
        ByteBuf nd = alloc.directBuffer(uncompressedBytes, uncompressedBytes);
        ByteBuf ndd = alloc.directBuffer(upperBound, upperBound);
        try {
            data.readBytes(nd);
            ByteBuffer d = nd.nioBuffer(0, uncompressedBytes);
            ByteBuffer dest = ndd.nioBuffer(0, upperBound);
            long compressedBytes = Zstd.compressDirectByteBuffer((ByteBuffer)dest, (int)5, (int)(upperBound - 5), (ByteBuffer)d, (int)0, (int)uncompressedBytes, (int)9);
            if (Zstd.isError((long)compressedBytes)) {
                throw new IOException((Throwable)new ZstdException(compressedBytes));
            }
            if ((double)uncompressedBytes / (double)(compressedBytes + 4L) < 1.1) {
                byte[] out = new byte[uncompressedBytes + 1];
                out[0] = 0;
                nd.readBytes(out, 1, uncompressedBytes);
                byte[] byArray = out;
                return byArray;
            }
            dest.put(0, (byte)1);
            dest.putInt(1, uncompressedBytes);
            dest.rewind();
            byte[] out = new byte[(int)compressedBytes + 5];
            dest.get(out);
            byte[] byArray = out;
            return byArray;
        }
        finally {
            nd.release();
            ndd.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected final ByteBuf decompressData(@Nullable ByteBuf data) throws IOException {
        boolean compressed;
        if (data == null || data.capacity() == 0) {
            return alloc.buffer(0, 0);
        }
        int compressedBytes = data.writerIndex();
        data.readerIndex(0);
        boolean bl = compressed = data.readByte() != 0;
        if (!compressed) {
            ByteBuf retVal = alloc.buffer(compressedBytes - 1, compressedBytes - 1);
            data.readBytes(retVal);
            return retVal;
        }
        int uncompressedBytes = data.readInt();
        ByteBuf nd = alloc.directBuffer(compressedBytes - 5, compressedBytes - 5);
        ByteBuf ndd = alloc.directBuffer(uncompressedBytes, uncompressedBytes);
        try {
            data.readBytes(nd);
            ByteBuffer d = nd.nioBuffer(0, compressedBytes - 5);
            ByteBuffer dest = ndd.nioBuffer(0, uncompressedBytes);
            long decompressedBytes = Zstd.decompressDirectByteBuffer((ByteBuffer)dest, (int)0, (int)uncompressedBytes, (ByteBuffer)d, (int)0, (int)(compressedBytes - 5));
            if (Zstd.isError((long)decompressedBytes)) {
                throw new IOException((Throwable)new ZstdException(decompressedBytes));
            }
            dest.rewind();
            ByteBuf retVal = alloc.buffer(uncompressedBytes, uncompressedBytes);
            retVal.writeBytes(dest);
            ByteBuf byteBuf = retVal;
            return byteBuf;
        }
        finally {
            nd.release();
            ndd.release();
        }
    }

    protected int getInitialCapacity() {
        this.capacityLock.readLock().lock();
        try {
            int n = this.capacity;
            return n;
        }
        finally {
            this.capacityLock.readLock().unlock();
        }
    }

    protected void addCapacity(int capacity) {
        int current = this.currentCapacity.getAndIncrement();
        if (current < 150) {
            this.capacities[current] = capacity;
        } else {
            this.capacityLock.writeLock().lock();
            try {
                this.capacity = MathUtil.percentile(this.capacities, 80.0);
                this.currentCapacity.set(0);
            }
            finally {
                this.capacityLock.writeLock().unlock();
            }
        }
    }

    protected final void dumpSentPacket(@NotNull ByteBuf buffer) throws IOException {
        File fileOnDisk;
        long current = this.currentSendPacket.getAndIncrement();
        if (this.sentPacketDirectory.exists() && !this.sentPacketDirectory.isDirectory()) {
            Files.delete(this.sentPacketDirectory.toPath());
        }
        if (!this.sentPacketDirectory.exists() && !this.sentPacketDirectory.mkdirs()) {
            throw new IOException("Could not create parent directory structure.");
        }
        if (current == 0L && this.sentPacketDirectory.exists()) {
            Files.delete(this.sentPacketDirectory.toPath());
            if (!this.sentPacketDirectory.mkdirs()) {
                throw new IOException("Could not create parent directory structure.");
            }
        }
        if ((fileOnDisk = new File(this.sentPacketDirectory, "packet-" + current + ".taco")).exists() && fileOnDisk.isDirectory()) {
            Files.delete(fileOnDisk.toPath());
        }
        int cap = Math.min(this.getInitialCapacity(), 4096);
        int index = buffer.readerIndex();
        try (FileOutputStream outputStream = new FileOutputStream(fileOnDisk);){
            byte[] buf = new byte[cap];
            while (buffer.readableBytes() > 0) {
                int read = Math.min(buf.length, buffer.readableBytes());
                buffer.readBytes(buf, 0, read);
                outputStream.write(buf, 0, read);
            }
        }
        catch (IOException ex) {
            this.logger.error(ex.getClass().getName() + ": " + ex.getMessage(), (Throwable)ex);
        }
        buffer.readerIndex(index);
    }

    protected final void dumpReceivedPacket(@NotNull ByteBuf buffer) throws IOException {
        File fileOnDisk;
        long current = this.currentReceivePacket.getAndIncrement();
        if (this.receivedPacketDirectory.exists() && !this.receivedPacketDirectory.isDirectory()) {
            Files.delete(this.receivedPacketDirectory.toPath());
        }
        if (!this.receivedPacketDirectory.exists() && !this.receivedPacketDirectory.mkdirs()) {
            throw new IOException("Could not create parent directory structure.");
        }
        if (current == 0L && this.receivedPacketDirectory.exists()) {
            Files.delete(this.receivedPacketDirectory.toPath());
            if (!this.receivedPacketDirectory.mkdirs()) {
                throw new IOException("Could not create parent directory structure.");
            }
        }
        if ((fileOnDisk = new File(this.receivedPacketDirectory, "packet-" + current + ".taco")).exists() && fileOnDisk.isDirectory()) {
            Files.delete(fileOnDisk.toPath());
        }
        int cap = Math.min(this.getInitialCapacity(), 4096);
        int index = buffer.readerIndex();
        try (FileOutputStream outputStream = new FileOutputStream(fileOnDisk);){
            byte[] buf = new byte[cap];
            while (buffer.readableBytes() > 0) {
                int read = Math.min(buf.length, buffer.readableBytes());
                buffer.readBytes(buf, 0, read);
                outputStream.write(buf, 0, read);
            }
        }
        catch (IOException ex) {
            this.logger.error(ex.getClass().getName() + ": " + ex.getMessage(), (Throwable)ex);
        }
        buffer.readerIndex(index);
    }

    protected static boolean hasVersion(@NotNull Packet packet) {
        if (packet instanceof InitializationPacket || packet instanceof PacketVersionPacket) {
            return true;
        }
        int i = 0;
        if (packet instanceof MultiPacket) {
            MultiPacket mult = (MultiPacket)packet;
            for (Packet p : mult.getPackets()) {
                if (p instanceof InitializationPacket || p instanceof PacketVersionPacket) {
                    if (i > 0) {
                        AbstractMessagingService.reorder(mult);
                    }
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private static void reorder(@NotNull MultiPacket packet) {
        LinkedHashSet<Packet> removedPackets = new LinkedHashSet<Packet>();
        LinkedHashSet<Packet> keptPackets = new LinkedHashSet<Packet>();
        for (Packet p : packet.getPackets()) {
            if (p instanceof InitializationPacket || p instanceof PacketVersionPacket) {
                removedPackets.add(p);
                continue;
            }
            keptPackets.add(p);
        }
        removedPackets.addAll(keptPackets);
        packet.setPackets(removedPackets);
    }

    protected void printBytes(@NotNull ByteBuf buffer) {
        StringBuilder sb = new StringBuilder();
        sb.append('\n');
        sb.append("-- Begin Message --");
        sb.append('\n');
        sb.append("Bytes:");
        sb.append('\n');
        int index = buffer.readerIndex();
        buffer.readerIndex(0);
        while (buffer.readableBytes() > 0) {
            sb.append(String.format("0x%02X ", buffer.readByte()));
        }
        sb.append('\n');
        buffer.readerIndex(0);
        while (buffer.readableBytes() > 0) {
            sb.append(String.format("%8s ", Integer.toBinaryString(buffer.readByte() & 0xFF)).replace(' ', '0')).append(' ');
        }
        sb.append('\n');
        buffer.readerIndex(0);
        while (buffer.readableBytes() > 0) {
            sb.append(buffer.readByte()).append(' ');
        }
        buffer.readerIndex(index);
        sb.append('\n');
        sb.append("-- End Message --");
        this.logger.info(sb.toString());
    }

    protected void printBytes(byte @NotNull [] bytes) {
        StringBuilder sb = new StringBuilder();
        sb.append('\n');
        sb.append("-- Begin Message --");
        sb.append('\n');
        sb.append("Bytes:");
        sb.append('\n');
        for (byte b : bytes) {
            sb.append(String.format("0x%02X ", b));
        }
        sb.append('\n');
        for (byte b : bytes) {
            sb.append(String.format("%8s ", Integer.toBinaryString(b & 0xFF)).replace(' ', '0')).append(' ');
        }
        sb.append('\n');
        for (byte b : bytes) {
            sb.append(b).append(' ');
        }
        sb.append('\n');
        sb.append("-- End Message --");
        this.logger.info(sb.toString());
    }
}

