/*
 * Decompiled with CFR 0.152.
 */
package carbonchat.libs.ninja.egg82.messenger;

import carbonchat.libs.io.nats.client.Connection;
import carbonchat.libs.io.nats.client.Dispatcher;
import carbonchat.libs.io.nats.client.Nats;
import carbonchat.libs.io.nats.client.Options;
import carbonchat.libs.ninja.egg82.messenger.AbstractMessagingService;
import carbonchat.libs.ninja.egg82.messenger.PacketManager;
import carbonchat.libs.ninja.egg82.messenger.core.Pair;
import carbonchat.libs.ninja.egg82.messenger.handler.MessagingHandler;
import carbonchat.libs.ninja.egg82.messenger.packets.Packet;
import carbonchat.libs.ninja.egg82.messenger.packets.server.KeepAlivePacket;
import carbonchat.libs.ninja.egg82.messenger.packets.server.PacketVersionRequestPacket;
import carbonchat.libs.ninja.egg82.messenger.services.CollectionProvider;
import carbonchat.libs.ninja.egg82.messenger.services.PacketService;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;

public class NATSMessagingService
extends AbstractMessagingService {
    private Connection connection;
    private Dispatcher dispatcher;
    private volatile boolean closed = false;
    private final ReadWriteLock queueLock = new ReentrantReadWriteLock();
    private final String subjectName;

    private NATSMessagingService(@NotNull PacketService packetService, @NotNull String name, @NotNull String channelName, long startupDelay, boolean dumpPackets, @NotNull File packetDirectory) {
        super(packetService, name, startupDelay, dumpPackets, packetDirectory);
        this.subjectName = channelName;
    }

    @Override
    public void close() {
        this.queueLock.writeLock().lock();
        try {
            this.closed = true;
            try {
                this.connection.closeDispatcher(this.dispatcher);
                this.connection.close();
            }
            catch (InterruptedException ignored) {
                this.packetService.removeMessenger(this);
                Thread.currentThread().interrupt();
            }
            this.packetService.removeMessenger(this);
        }
        finally {
            this.queueLock.writeLock().unlock();
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed || this.connection.getConnectedUrl() == null;
    }

    @NotNull
    public static Builder builder(@NotNull PacketService packetService, @NotNull String name, @NotNull String channelName, @NotNull UUID serverId, @NotNull MessagingHandler handler, long startupDelay, boolean dumpPackets, @NotNull File packetDirectory) {
        return new Builder(packetService, name, channelName, serverId, handler, startupDelay, dumpPackets, packetDirectory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendPacket(@NotNull UUID messageId, @NotNull Packet packet) throws IOException {
        this.queueLock.readLock().lock();
        try {
            ByteBuf buffer = alloc.buffer(this.getInitialCapacity());
            try {
                buffer.writeBytes(this.serverIdBytes);
                buffer.writeLong(messageId.getMostSignificantBits());
                buffer.writeLong(messageId.getLeastSignificantBits());
                buffer.writeByte(PacketManager.getId(packet.getClass()));
                packet.write(buffer);
                this.addCapacity(buffer.writerIndex());
                if (this.dumpPackets) {
                    this.dumpSentPacket(buffer);
                }
                this.connection.publish(this.subjectName, this.compressData(buffer));
            }
            finally {
                buffer.release();
            }
        }
        catch (IllegalStateException ex) {
            throw new IOException(ex);
        }
        finally {
            this.queueLock.readLock().unlock();
        }
    }

    public static class Builder {
        private final NATSMessagingService service;
        private final Options.Builder config = new Options.Builder();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Builder(@NotNull PacketService packetService, @NotNull String name, @NotNull String channelName, @NotNull UUID serverId, @NotNull MessagingHandler handler, long startupDelay, boolean dumpPackets, @NotNull File packetDirectory) {
            this.service = new NATSMessagingService(packetService, name, channelName, startupDelay, dumpPackets, packetDirectory);
            this.service.serverId = serverId;
            this.service.serverIdString = serverId.toString();
            ByteBuf buffer = AbstractMessagingService.alloc.buffer(16, 16);
            try {
                buffer.writeLong(serverId.getMostSignificantBits());
                buffer.writeLong(serverId.getLeastSignificantBits());
                if (buffer.isDirect()) {
                    this.service.serverIdBytes = new byte[16];
                    buffer.readBytes(this.service.serverIdBytes);
                } else {
                    this.service.serverIdBytes = buffer.array();
                }
            }
            finally {
                buffer.release();
            }
            this.service.handler = handler;
        }

        @NotNull
        public Builder url(@NotNull String address, int port) {
            this.config.server("nats://" + address + ":" + port);
            return this;
        }

        @NotNull
        public Builder credentials(@NotNull String file) {
            this.config.authHandler(Nats.credentials((String)file));
            return this;
        }

        @NotNull
        public Builder life(int timeout) {
            this.config.connectionTimeout(Duration.ofMillis(timeout));
            return this;
        }

        @NotNull
        public NATSMessagingService build() throws IOException, InterruptedException {
            this.service.connection = Nats.connect((Options)this.config.build());
            if (this.service.startupDelay == 0L) {
                this.subscribe();
                this.service.packetService.addMessenger(this.service);
            } else {
                CompletableFuture.runAsync(() -> {
                    try {
                        Thread.sleep(this.service.startupDelay);
                    }
                    catch (InterruptedException ex) {
                        this.service.logger.error(ex.getClass().getName() + ": " + ex.getMessage(), (Throwable)ex);
                        Thread.currentThread().interrupt();
                    }
                }).thenRun(() -> {
                    this.subscribe();
                    this.service.packetService.addMessenger(this.service);
                });
            }
            return this.service;
        }

        private void subscribe() {
            this.service.dispatcher = this.service.connection.createDispatcher(message -> {
                String subject = message.getSubject();
                try {
                    if (this.service.subjectName.equals(subject)) {
                        this.handleMessage(message.getData());
                    } else {
                        this.service.logger.warn("Got data from subject that should not exist: " + subject);
                    }
                }
                catch (IOException ex) {
                    this.service.logger.error("Could not handle message.", (Throwable)ex);
                }
            });
            this.service.dispatcher.subscribe(this.service.subjectName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleMessage(byte @NotNull [] body) throws IOException {
            ByteBuf b = AbstractMessagingService.alloc.buffer(body.length, body.length);
            ByteBuf data = null;
            try {
                Object packet;
                UUID sender;
                b.writeBytes(body);
                data = this.service.decompressData(b);
                if (this.service.dumpPackets) {
                    this.service.dumpReceivedPacket(data);
                }
                if (this.service.serverId.equals(sender = new UUID(data.readLong(), data.readLong()))) {
                    return;
                }
                byte packetVersion = CollectionProvider.getServerVersions().getOrDefault((Object)sender, (byte)-1);
                if (packetVersion > -1 && packetVersion != this.service.packetService.getPacketVersion()) {
                    this.service.logger.warn("Server " + sender + " packet version " + String.format("0x%02X ", packetVersion) + " does not match current packet version " + String.format("0x%02X ", this.service.packetService.getPacketVersion()) + ". Skipping packet.");
                    return;
                }
                UUID messageId = new UUID(data.readLong(), data.readLong());
                byte packetId = data.readByte();
                try {
                    packet = PacketManager.read(packetId, sender, data);
                    if (packet == null) {
                        this.service.logger.warn("Received packet ID that doesn't exist: " + packetId);
                        return;
                    }
                }
                catch (Exception ex) {
                    Class<? extends Packet> clazz = PacketManager.getPacket(packetId);
                    this.service.logger.error("Could not instantiate packet" + (clazz != null ? clazz.getName() : "null"), (Throwable)ex);
                    return;
                }
                if (packetVersion == -1 && packet instanceof KeepAlivePacket) {
                    return;
                }
                if (packetVersion == -1 && !AbstractMessagingService.hasVersion(packet)) {
                    this.service.logger.warn("Server " + sender + " packet version is unknown, and packet type is of " + packet.getClass().getName() + ". Skipping packet.");
                    ByteBuf finalData = data;
                    CollectionProvider.getPacketProcessingQueue().compute(sender, (k, v) -> {
                        if (v == null) {
                            v = new CopyOnWriteArrayList<Pair<UUID, Packet>>();
                        }
                        if (v.isEmpty()) {
                            if (packet.verifyFullRead(finalData)) {
                                v.add(new Pair<UUID, Packet>(messageId, (Packet)packet));
                            }
                            this.service.packetService.queuePacket(new PacketVersionRequestPacket(sender, this.service.serverId));
                        } else if (packet.verifyFullRead(finalData)) {
                            v.add(new Pair<UUID, Packet>(messageId, (Packet)packet));
                        }
                        return v;
                    });
                    return;
                }
                if (packet.verifyFullRead(data)) {
                    this.service.handler.handlePacket(messageId, this.service.getName(), (Packet)packet);
                }
            }
            finally {
                b.release();
                if (data != null) {
                    data.release();
                }
            }
        }
    }
}

