/*
 * Decompiled with CFR 0.152.
 */
package carbonchat.libs.ninja.egg82.messenger;

import carbonchat.libs.ninja.egg82.messenger.PacketSupplier;
import carbonchat.libs.ninja.egg82.messenger.packets.Packet;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PacketManager {
    private static final Set<Class<? extends Packet>> registeredPackets = new CopyOnWriteArraySet<Class<? extends Packet>>();
    private static final Int2ObjectMap<Class<? extends Packet>> packetsById = new Int2ObjectArrayMap();
    private static final Object2IntMap<Class<? extends Packet>> packets = new Object2IntArrayMap();
    private static final Int2ObjectMap<PacketSupplier<? extends Packet>> suppliersById = new Int2ObjectArrayMap();
    private static final AtomicInteger currentId = new AtomicInteger(0);

    private PacketManager() {
    }

    public static <T extends Packet> void register(@NotNull Class<T> clazz, @NotNull PacketSupplier<T> supplier) {
        if (!registeredPackets.add(clazz)) {
            throw new IllegalStateException("Packet " + clazz.getName() + " has already been registered.");
        }
        int id = currentId.incrementAndGet();
        packetsById.put(id, clazz);
        packets.put(clazz, id);
        suppliersById.put(id, supplier);
    }

    @Nullable
    public static Class<? extends Packet> getPacket(int id) {
        return (Class)packetsById.get(id);
    }

    public static int getId(Class<? extends Packet> clazz) {
        return packets.getOrDefault(clazz, -1);
    }

    @Nullable
    public static <T extends Packet> T read(int id, @NotNull UUID sender, @NotNull ByteBuf buffer) {
        PacketSupplier retVal = (PacketSupplier)suppliersById.get(id);
        return retVal != null ? (T)retVal.create(sender, buffer) : null;
    }
}

