/*
 * Decompiled with CFR 0.152.
 */
package carbonchat.libs.ninja.egg82.messenger;

import carbonchat.libs.com.rabbitmq.client.AMQP;
import carbonchat.libs.com.rabbitmq.client.Channel;
import carbonchat.libs.com.rabbitmq.client.ConnectionFactory;
import carbonchat.libs.com.rabbitmq.client.Consumer;
import carbonchat.libs.com.rabbitmq.client.DefaultConsumer;
import carbonchat.libs.com.rabbitmq.client.Envelope;
import carbonchat.libs.com.rabbitmq.client.RecoverableChannel;
import carbonchat.libs.com.rabbitmq.client.RecoverableConnection;
import carbonchat.libs.ninja.egg82.messenger.AbstractMessagingService;
import carbonchat.libs.ninja.egg82.messenger.PacketManager;
import carbonchat.libs.ninja.egg82.messenger.core.Pair;
import carbonchat.libs.ninja.egg82.messenger.handler.MessagingHandler;
import carbonchat.libs.ninja.egg82.messenger.packets.Packet;
import carbonchat.libs.ninja.egg82.messenger.packets.server.KeepAlivePacket;
import carbonchat.libs.ninja.egg82.messenger.packets.server.PacketVersionRequestPacket;
import carbonchat.libs.ninja.egg82.messenger.services.CollectionProvider;
import carbonchat.libs.ninja.egg82.messenger.services.PacketService;
import carbonchat.libs.ninja.egg82.messenger.utils.ValidationUtil;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RabbitMQMessagingService
extends AbstractMessagingService {
    private ConnectionFactory factory;
    private RecoverableConnection connection;
    private volatile boolean closed = false;
    private final ReadWriteLock queueLock = new ReentrantReadWriteLock();
    private final String exchangeName;

    private RabbitMQMessagingService(@NotNull PacketService packetService, @NotNull String name, @NotNull String channelName, long startupDelay, boolean dumpPackets, @NotNull File packetDirectory) {
        super(packetService, name, startupDelay, dumpPackets, packetDirectory);
        this.exchangeName = channelName;
    }

    @Override
    public void close() {
        this.queueLock.writeLock().lock();
        try {
            this.closed = true;
            try {
                this.connection.close(8000);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.packetService.removeMessenger(this);
        }
        finally {
            this.queueLock.writeLock().unlock();
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed || !this.connection.isOpen();
    }

    @NotNull
    public static Builder builder(@NotNull PacketService packetService, @NotNull String name, @NotNull String channelName, @NotNull UUID serverId, @NotNull MessagingHandler handler, long startupDelay, boolean dumpPackets, @NotNull File packetDirectory) {
        return new Builder(packetService, name, channelName, serverId, handler, startupDelay, dumpPackets, packetDirectory);
    }

    private void bind() throws IOException {
        RecoverableChannel channel = this.getChannel();
        channel.exchangeDeclare(this.exchangeName, ExchangeType.FANOUT.getType(), true);
        String queue = channel.queueDeclare().getQueue();
        channel.queueBind(queue, this.exchangeName, "");
        DefaultConsumer consumer = new DefaultConsumer((Channel)channel){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleDelivery(String tag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
                UUID sender = RabbitMQMessagingService.this.validateProperties(properties);
                if (sender == null) {
                    return;
                }
                byte packetVersion = CollectionProvider.getServerVersions().getOrDefault((Object)sender, (byte)-1);
                if (packetVersion > -1 && packetVersion != RabbitMQMessagingService.this.packetService.getPacketVersion()) {
                    RabbitMQMessagingService.this.logger.warn("Server " + sender + " packet version " + String.format("0x%02X ", packetVersion) + " does not match current packet version " + String.format("0x%02X ", RabbitMQMessagingService.this.packetService.getPacketVersion()) + ". Skipping packet.");
                    return;
                }
                ByteBuf b = AbstractMessagingService.alloc.buffer(body.length, body.length);
                ByteBuf data = null;
                try {
                    Object packet;
                    b.writeBytes(body);
                    data = RabbitMQMessagingService.this.decompressData(b);
                    if (RabbitMQMessagingService.this.dumpPackets) {
                        RabbitMQMessagingService.this.dumpReceivedPacket(data);
                    }
                    byte packetId = data.readByte();
                    try {
                        packet = PacketManager.read(packetId, sender, data);
                        if (packet == null) {
                            RabbitMQMessagingService.this.logger.warn("Received packet ID that doesn't exist: " + packetId);
                            return;
                        }
                    }
                    catch (Exception ex) {
                        Class<? extends Packet> clazz = PacketManager.getPacket(packetId);
                        RabbitMQMessagingService.this.logger.error("Could not instantiate packet" + (clazz != null ? clazz.getName() : "null"), (Throwable)ex);
                        return;
                    }
                    if (packetVersion == -1 && packet instanceof KeepAlivePacket) {
                        return;
                    }
                    if (packetVersion == -1 && !AbstractMessagingService.hasVersion(packet)) {
                        RabbitMQMessagingService.this.logger.warn("Server " + sender + " packet version is unknown, and packet type is of " + packet.getClass().getName() + ". Skipping packet.");
                        ByteBuf finalData = data;
                        CollectionProvider.getPacketProcessingQueue().compute(sender, (k, v) -> {
                            if (v == null) {
                                v = new CopyOnWriteArrayList<Pair<UUID, Packet>>();
                            }
                            if (v.isEmpty()) {
                                if (packet.verifyFullRead(finalData)) {
                                    v.add(new Pair<UUID, Packet>(UUID.fromString(properties.getMessageId()), (Packet)packet));
                                }
                                RabbitMQMessagingService.this.packetService.queuePacket(new PacketVersionRequestPacket(sender, RabbitMQMessagingService.this.serverId));
                            } else if (packet.verifyFullRead(finalData)) {
                                v.add(new Pair<UUID, Packet>(UUID.fromString(properties.getMessageId()), (Packet)packet));
                            }
                            return v;
                        });
                        return;
                    }
                    if (packet.verifyFullRead(data)) {
                        RabbitMQMessagingService.this.handler.handlePacket(UUID.fromString(properties.getMessageId()), RabbitMQMessagingService.this.getName(), (Packet)packet);
                    }
                }
                finally {
                    b.release();
                    if (data != null) {
                        data.release();
                    }
                }
            }
        };
        channel.addShutdownListener(cause -> {
            try {
                this.bind();
            }
            catch (IOException ex) {
                this.logger.error("Could not re-bind channel.", (Throwable)ex);
            }
        });
        channel.basicConsume(queue, true, (Consumer)consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendPacket(@NotNull UUID messageId, @NotNull Packet packet) throws IOException, TimeoutException {
        this.queueLock.readLock().lock();
        try (RecoverableChannel channel = this.getChannel();){
            ByteBuf buffer = alloc.buffer(this.getInitialCapacity());
            try {
                buffer.writeByte(PacketManager.getId(packet.getClass()));
                packet.write(buffer);
                this.addCapacity(buffer.writerIndex());
                if (this.dumpPackets) {
                    this.dumpSentPacket(buffer);
                }
                AMQP.BasicProperties properties = this.getProperties(DeliveryMode.PERSISTENT, messageId);
                channel.exchangeDeclare(this.exchangeName, ExchangeType.FANOUT.getType(), true);
                channel.basicPublish(this.exchangeName, "", properties, this.compressData(buffer));
            }
            finally {
                buffer.release();
            }
        }
        finally {
            this.queueLock.readLock().unlock();
        }
    }

    @NotNull
    private AMQP.BasicProperties getProperties(@NotNull DeliveryMode deliveryMode, @NotNull UUID messageId) {
        HashMap<String, byte[]> headers = new HashMap<String, byte[]>();
        headers.put("sender", this.serverIdBytes);
        AMQP.BasicProperties.Builder retVal = new AMQP.BasicProperties.Builder();
        retVal.contentType("application/octet-stream");
        retVal.messageId(messageId.toString());
        retVal.deliveryMode(Integer.valueOf(deliveryMode.getMode()));
        retVal.headers(headers);
        return retVal.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private UUID validateProperties(@NotNull AMQP.BasicProperties properties) {
        UUID sender;
        byte[] data = (byte[])properties.getHeaders().get("sender");
        ByteBuf buffer = alloc.buffer(16, 16);
        try {
            buffer.writeBytes(data);
            sender = new UUID(buffer.readLong(), buffer.readLong());
        }
        finally {
            buffer.release();
        }
        if (this.serverId.equals(sender)) {
            return null;
        }
        if (!ValidationUtil.isValidUuid(properties.getMessageId())) {
            this.logger.warn("Non-valid message ID received: \"" + properties.getMessageId() + "\".");
            return null;
        }
        return sender;
    }

    @NotNull
    private RecoverableConnection getConnection() throws IOException, TimeoutException {
        return (RecoverableConnection)this.factory.newConnection();
    }

    @NotNull
    private RecoverableChannel getChannel() throws IOException {
        return (RecoverableChannel)this.connection.createChannel();
    }

    public static class Builder {
        private final RabbitMQMessagingService service;
        private final ConnectionFactory config = new ConnectionFactory();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Builder(@NotNull PacketService packetService, @NotNull String name, @NotNull String channelName, @NotNull UUID serverId, @NotNull MessagingHandler handler, long startupDelay, boolean dumpPackets, @NotNull File packetDirectory) {
            this.service = new RabbitMQMessagingService(packetService, name, channelName, startupDelay, dumpPackets, packetDirectory);
            this.service.serverId = serverId;
            this.service.serverIdString = serverId.toString();
            ByteBuf buffer = AbstractMessagingService.alloc.buffer(16, 16);
            try {
                buffer.writeLong(serverId.getMostSignificantBits());
                buffer.writeLong(serverId.getLeastSignificantBits());
                if (buffer.isDirect()) {
                    this.service.serverIdBytes = new byte[16];
                    buffer.readBytes(this.service.serverIdBytes);
                } else {
                    this.service.serverIdBytes = buffer.array();
                }
            }
            finally {
                buffer.release();
            }
            this.service.handler = handler;
            this.config.setAutomaticRecoveryEnabled(true);
            this.config.setTopologyRecoveryEnabled(true);
        }

        @NotNull
        public Builder url(@NotNull String address, int port, @NotNull String vhost) {
            this.config.setHost(address);
            this.config.setPort(port);
            this.config.setVirtualHost(vhost);
            return this;
        }

        @NotNull
        public Builder credentials(@NotNull String user, @NotNull String pass) {
            this.config.setUsername(user);
            this.config.setPassword(pass);
            return this;
        }

        @NotNull
        public Builder timeout(int timeout) {
            this.config.setConnectionTimeout(timeout);
            return this;
        }

        @NotNull
        public RabbitMQMessagingService build() throws IOException, TimeoutException {
            this.service.factory = this.config;
            this.service.connection = this.service.getConnection();
            if (this.service.startupDelay == 0L) {
                this.service.bind();
                this.service.packetService.addMessenger(this.service);
            } else {
                CompletableFuture.runAsync(() -> {
                    try {
                        Thread.sleep(this.service.startupDelay);
                    }
                    catch (InterruptedException ex) {
                        this.service.logger.error(ex.getClass().getName() + ": " + ex.getMessage(), (Throwable)ex);
                        Thread.currentThread().interrupt();
                    }
                }).thenRun(() -> {
                    try {
                        this.service.bind();
                        this.service.packetService.addMessenger(this.service);
                    }
                    catch (IOException ex) {
                        this.service.logger.error(ex.getClass().getName() + ": " + ex.getMessage(), (Throwable)ex);
                        throw new CompletionException(ex);
                    }
                });
            }
            return this.service;
        }
    }

    private static enum ExchangeType {
        DIRECT("direct"),
        FANOUT("fanout"),
        TOPIC("topic"),
        HEADERS("match");

        private final String type;

        private ExchangeType(String type) {
            this.type = type;
        }

        @NotNull
        public String getType() {
            return this.type;
        }
    }

    private static enum DeliveryMode {
        TRANSIENT(1),
        PERSISTENT(2);

        private final int mode;

        private DeliveryMode(int mode) {
            this.mode = mode;
        }

        public int getMode() {
            return this.mode;
        }
    }
}

