/*
 * Decompiled with CFR 0.152.
 */
package carbonchat.libs.ninja.egg82.messenger;

import carbonchat.libs.ninja.egg82.messenger.AbstractMessagingService;
import carbonchat.libs.ninja.egg82.messenger.PacketManager;
import carbonchat.libs.ninja.egg82.messenger.core.Pair;
import carbonchat.libs.ninja.egg82.messenger.handler.MessagingHandler;
import carbonchat.libs.ninja.egg82.messenger.packets.Packet;
import carbonchat.libs.ninja.egg82.messenger.packets.server.KeepAlivePacket;
import carbonchat.libs.ninja.egg82.messenger.packets.server.PacketVersionRequestPacket;
import carbonchat.libs.ninja.egg82.messenger.services.CollectionProvider;
import carbonchat.libs.ninja.egg82.messenger.services.PacketService;
import carbonchat.libs.org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import carbonchat.libs.redis.clients.jedis.BinaryJedisPubSub;
import carbonchat.libs.redis.clients.jedis.Jedis;
import carbonchat.libs.redis.clients.jedis.JedisPool;
import carbonchat.libs.redis.clients.jedis.JedisPoolConfig;
import carbonchat.libs.redis.clients.jedis.exceptions.JedisException;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;

public class RedisMessagingService
extends AbstractMessagingService {
    private final ExecutorService workPool = Executors.newFixedThreadPool(1);
    private JedisPool pool;
    private final PubSub pubSub = new PubSub(this);
    private volatile boolean closed = false;
    private final ReadWriteLock queueLock = new ReentrantReadWriteLock();
    private final List<Jedis> blockedConnections = new CopyOnWriteArrayList<Jedis>();
    private final String channelName;
    private final byte[] channelNameBytes;

    private RedisMessagingService(@NotNull PacketService packetService, @NotNull String name, @NotNull String channelName, long startupDelay, boolean dumpPackets, @NotNull File packetDirectory) {
        super(packetService, name, startupDelay, dumpPackets, packetDirectory);
        this.channelName = channelName;
        this.channelNameBytes = channelName.getBytes(StandardCharsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.queueLock.writeLock().lock();
        try {
            this.closed = true;
            for (Jedis blockedConnection : this.blockedConnections) {
                try {
                    blockedConnection.getClient().disconnect();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            this.workPool.shutdown();
            try {
                if (!this.workPool.awaitTermination(4L, TimeUnit.SECONDS)) {
                    this.workPool.shutdownNow();
                }
            }
            catch (InterruptedException ignored) {
                this.packetService.removeMessenger(this);
                Thread.currentThread().interrupt();
            }
            this.pool.close();
            this.packetService.removeMessenger(this);
        }
        finally {
            this.queueLock.writeLock().unlock();
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed || this.pool.isClosed();
    }

    @NotNull
    public static Builder builder(@NotNull PacketService packetService, @NotNull String name, @NotNull String channelName, @NotNull UUID serverId, @NotNull MessagingHandler handler, long startupDelay, boolean dumpPackets, @NotNull File packetDirectory) {
        return new Builder(packetService, name, channelName, serverId, handler, startupDelay, dumpPackets, packetDirectory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendPacket(@NotNull UUID messageId, @NotNull Packet packet) throws IOException {
        this.queueLock.readLock().lock();
        try (Jedis redis = this.pool.getResource();){
            ByteBuf buffer = alloc.buffer(this.getInitialCapacity());
            try {
                buffer.writeBytes(this.serverIdBytes);
                buffer.writeLong(messageId.getMostSignificantBits());
                buffer.writeLong(messageId.getLeastSignificantBits());
                buffer.writeByte(PacketManager.getId(packet.getClass()));
                packet.write(buffer);
                this.addCapacity(buffer.writerIndex());
                if (this.dumpPackets) {
                    this.dumpSentPacket(buffer);
                }
                redis.publish(this.channelNameBytes, this.compressData(buffer));
            }
            finally {
                buffer.release();
            }
        }
        catch (JedisException ex) {
            throw new IOException(ex);
        }
        finally {
            this.queueLock.readLock().unlock();
        }
    }

    private static class PubSub
    extends BinaryJedisPubSub {
        private final RedisMessagingService service;

        private PubSub(@NotNull RedisMessagingService service) {
            this.service = service;
        }

        public void onMessage(byte @NotNull [] c, byte @NotNull [] m) {
            String channel = new String(c, StandardCharsets.UTF_8);
            try {
                if (this.service.channelName.equals(channel)) {
                    this.handleMessage(m);
                } else {
                    this.service.logger.warn("Got data from channel that should not exist: " + channel);
                }
            }
            catch (IOException ex) {
                this.service.logger.error("Could not handle message.", (Throwable)ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleMessage(byte @NotNull [] body) throws IOException {
            ByteBuf b = AbstractMessagingService.alloc.buffer(body.length, body.length);
            ByteBuf data = null;
            try {
                Object packet;
                UUID sender;
                b.writeBytes(body);
                data = this.service.decompressData(b);
                if (this.service.dumpPackets) {
                    this.service.dumpReceivedPacket(data);
                }
                if (this.service.serverId.equals(sender = new UUID(data.readLong(), data.readLong()))) {
                    return;
                }
                byte packetVersion = CollectionProvider.getServerVersions().getOrDefault((Object)sender, (byte)-1);
                if (packetVersion > -1 && packetVersion != this.service.packetService.getPacketVersion()) {
                    this.service.logger.warn("Server " + sender + " packet version " + String.format("0x%02X ", packetVersion) + " does not match current packet version " + String.format("0x%02X ", this.service.packetService.getPacketVersion()) + ". Skipping packet.");
                    return;
                }
                UUID messageId = new UUID(data.readLong(), data.readLong());
                byte packetId = data.readByte();
                try {
                    packet = PacketManager.read(packetId, sender, data);
                    if (packet == null) {
                        this.service.logger.warn("Received packet ID that doesn't exist: " + packetId);
                        return;
                    }
                }
                catch (Exception ex) {
                    Class<? extends Packet> clazz = PacketManager.getPacket(packetId);
                    this.service.logger.error("Could not instantiate packet" + (clazz != null ? clazz.getName() : "null"), (Throwable)ex);
                    return;
                }
                if (packetVersion == -1 && packet instanceof KeepAlivePacket) {
                    return;
                }
                if (packetVersion == -1 && !AbstractMessagingService.hasVersion(packet)) {
                    this.service.logger.warn("Server " + sender + " packet version is unknown, and packet type is of " + packet.getClass().getName() + ". Skipping packet.");
                    ByteBuf finalData = data;
                    CollectionProvider.getPacketProcessingQueue().compute(sender, (k, v) -> {
                        if (v == null) {
                            v = new CopyOnWriteArrayList<Pair<UUID, Packet>>();
                        }
                        if (v.isEmpty()) {
                            if (packet.verifyFullRead(finalData)) {
                                v.add(new Pair<UUID, Packet>(messageId, (Packet)packet));
                            }
                            this.service.packetService.queuePacket(new PacketVersionRequestPacket(sender, this.service.serverId));
                        } else if (packet.verifyFullRead(finalData)) {
                            v.add(new Pair<UUID, Packet>(messageId, (Packet)packet));
                        }
                        return v;
                    });
                    return;
                }
                if (packet.verifyFullRead(data)) {
                    this.service.handler.handlePacket(messageId, this.service.getName(), (Packet)packet);
                }
            }
            finally {
                b.release();
                if (data != null) {
                    data.release();
                }
            }
        }
    }

    public static class Builder {
        private final RedisMessagingService service;
        private final JedisPoolConfig config = new JedisPoolConfig();
        private String address = "127.0.0.1";
        private int port = 6379;
        private int timeout = 5000;
        private String pass = "";

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Builder(@NotNull PacketService packetService, @NotNull String name, @NotNull String channelName, @NotNull UUID serverId, @NotNull MessagingHandler handler, long startupDelay, boolean dumpPackets, @NotNull File packetDirectory) {
            this.service = new RedisMessagingService(packetService, name, channelName, startupDelay, dumpPackets, packetDirectory);
            this.service.serverId = serverId;
            this.service.serverIdString = serverId.toString();
            ByteBuf buffer = AbstractMessagingService.alloc.buffer(16, 16);
            try {
                buffer.writeLong(serverId.getMostSignificantBits());
                buffer.writeLong(serverId.getLeastSignificantBits());
                if (buffer.isDirect()) {
                    this.service.serverIdBytes = new byte[16];
                    buffer.readBytes(this.service.serverIdBytes);
                } else {
                    this.service.serverIdBytes = buffer.array();
                }
            }
            finally {
                buffer.release();
            }
            this.service.handler = handler;
        }

        @NotNull
        public Builder url(@NotNull String address, int port) {
            this.address = address;
            this.port = port;
            return this;
        }

        @NotNull
        public Builder credentials(@NotNull String pass) {
            this.pass = pass;
            return this;
        }

        @NotNull
        public Builder poolSize(int min, int max) {
            this.config.setMinIdle(min);
            this.config.setMaxTotal(max);
            return this;
        }

        @NotNull
        public Builder life(long lifetime, int timeout) {
            this.config.setMinEvictableIdleTimeMillis(lifetime);
            this.config.setMaxWaitMillis((long)timeout);
            this.timeout = timeout;
            return this;
        }

        @NotNull
        public RedisMessagingService build() {
            this.service.pool = new JedisPool((GenericObjectPoolConfig)this.config, this.address, this.port, this.timeout, this.pass == null || this.pass.isEmpty() ? null : this.pass);
            this.warmup(this.service.pool);
            this.subscribe();
            return this.service;
        }

        private void subscribe() {
            this.service.workPool.execute(() -> {
                if (this.service.startupDelay > 0L) {
                    try {
                        Thread.sleep(this.service.startupDelay);
                    }
                    catch (InterruptedException ex) {
                        this.service.logger.error(ex.getClass().getName() + ": " + ex.getMessage(), (Throwable)ex);
                        Thread.currentThread().interrupt();
                    }
                }
                this.service.packetService.addMessenger(this.service);
                int failures = 0;
                while (!this.service.isClosed()) {
                    if (failures > 0) {
                        try {
                            Thread.sleep((long)failures * 50L);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    Jedis j = null;
                    try {
                        Jedis redis = this.service.pool.getResource();
                        try {
                            j = redis;
                            this.service.blockedConnections.add(redis);
                            redis.subscribe((BinaryJedisPubSub)this.service.pubSub, (byte[][])new byte[][]{this.service.channelNameBytes});
                        }
                        finally {
                            if (redis == null) continue;
                            redis.close();
                        }
                    }
                    catch (JedisException ex) {
                        if (this.service.isClosed()) continue;
                        ++failures;
                        this.service.logger.warn("Redis pub/sub disconnected. Reconnecting..");
                    }
                    finally {
                        if (j == null) continue;
                        this.service.blockedConnections.remove(j);
                    }
                }
            });
        }

        private void warmup(@NotNull JedisPool pool) {
            Jedis jedis;
            int i;
            Jedis[] warmpupArr = new Jedis[this.config.getMinIdle()];
            for (i = 0; i < this.config.getMinIdle(); ++i) {
                warmpupArr[i] = jedis = pool.getResource();
                jedis.ping();
            }
            for (i = 0; i < this.config.getMinIdle(); ++i) {
                jedis = warmpupArr[i];
                jedis.close();
            }
        }
    }
}

