/*
 * Decompiled with CFR 0.152.
 */
package carbonchat.libs.ninja.egg82.messenger.core;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;

public class DoubleBuffer<T> {
    private final AtomicReference<Queue<T>> currentBuffer = new AtomicReference(new ConcurrentLinkedQueue());
    private final AtomicReference<Queue<T>> backBuffer = new AtomicReference(new ConcurrentLinkedQueue());
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    @NotNull
    public Queue<T> getReadBuffer() {
        this.lock.readLock().lock();
        try {
            Queue<T> queue = this.backBuffer.get();
            return queue;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @NotNull
    public Queue<T> getWriteBuffer() {
        this.lock.readLock().lock();
        try {
            Queue<T> queue = this.currentBuffer.get();
            return queue;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void swapBuffers() {
        this.lock.writeLock().lock();
        try {
            this.backBuffer.set(this.currentBuffer.getAndSet(this.backBuffer.get()));
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

