/*
 * Decompiled with CFR 0.152.
 */
package carbonchat.libs.ninja.egg82.messenger.handler;

import carbonchat.libs.com.github.benmanes.caffeine.cache.Cache;
import carbonchat.libs.com.github.benmanes.caffeine.cache.Caffeine;
import carbonchat.libs.ninja.egg82.messenger.handler.AbstractMessagingHandler;
import carbonchat.libs.ninja.egg82.messenger.handler.MessagingHandler;
import carbonchat.libs.ninja.egg82.messenger.packets.Packet;
import carbonchat.libs.ninja.egg82.messenger.packets.server.InitializationPacket;
import carbonchat.libs.ninja.egg82.messenger.packets.server.KeepAlivePacket;
import carbonchat.libs.ninja.egg82.messenger.packets.server.PacketVersionPacket;
import carbonchat.libs.ninja.egg82.messenger.packets.server.PacketVersionRequestPacket;
import carbonchat.libs.ninja.egg82.messenger.packets.server.ShutdownPacket;
import carbonchat.libs.ninja.egg82.messenger.services.CollectionProvider;
import carbonchat.libs.ninja.egg82.messenger.services.PacketService;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractServerMessagingHandler
extends AbstractMessagingHandler {
    private final Cache<UUID, Long> aliveServers = Caffeine.newBuilder().expireAfterWrite(20L, TimeUnit.SECONDS).evictionListener((uuid, timestamp, cause) -> {
        this.logger.warn("Server " + uuid + " has either shut down or timed out. Clearing its data.");
        if (uuid != null) {
            this.handleShutdown((UUID)uuid);
        }
    }).build();
    private final UUID serverId;
    private final MessagingHandler messagingHandler;

    protected AbstractServerMessagingHandler(@NotNull UUID serverId, @NotNull PacketService packetService, @NotNull MessagingHandler messagingHandler) {
        super(packetService);
        this.serverId = serverId;
        this.messagingHandler = messagingHandler;
    }

    @Override
    protected boolean handlePacket(@NotNull Packet packet) {
        if (packet instanceof KeepAlivePacket) {
            this.handleKeepalive((KeepAlivePacket)packet);
            return true;
        }
        if (packet instanceof InitializationPacket) {
            this.handleInitialization((InitializationPacket)packet);
            return true;
        }
        if (packet instanceof PacketVersionPacket) {
            this.handlePacketVersion((PacketVersionPacket)packet);
            return true;
        }
        if (packet instanceof PacketVersionRequestPacket) {
            this.handlePacketVersionRequest((PacketVersionRequestPacket)packet);
            return true;
        }
        if (packet instanceof ShutdownPacket) {
            this.handleShutdown((ShutdownPacket)packet);
            return true;
        }
        return false;
    }

    protected void handleKeepalive(@NotNull KeepAlivePacket packet) {
        this.aliveServers.put((Object)packet.getSender(), (Object)System.currentTimeMillis());
    }

    protected void handleInitialization(@NotNull InitializationPacket packet) {
        CollectionProvider.getServerVersions().put((Object)packet.getServer(), packet.getPacketVersion());
        this.packetService.queuePackets(new PacketVersionPacket(packet.getServer(), this.serverId, this.packetService.getPacketVersion()));
    }

    protected void handlePacketVersion(@NotNull PacketVersionPacket packet) {
        if (!packet.getIntendedRecipient().equals(this.serverId)) {
            return;
        }
        CollectionProvider.getServerVersions().put((Object)packet.getServer(), packet.getPacketVersion());
        this.messagingHandler.flushPacketBuffer(packet.getServer());
    }

    protected void handlePacketVersionRequest(@NotNull PacketVersionRequestPacket packet) {
        if (!packet.getIntendedRecipient().equals(this.serverId)) {
            return;
        }
        this.packetService.queuePacket(new PacketVersionPacket(packet.getServer(), packet.getIntendedRecipient(), this.packetService.getPacketVersion()));
    }

    protected void handleShutdown(@NotNull ShutdownPacket packet) {
        this.aliveServers.invalidate((Object)packet.getServer());
        this.handleShutdown(packet.getServer());
    }

    protected void handleShutdown(@NotNull UUID serverId) {
        CollectionProvider.getServerVersions().removeByte((Object)serverId);
    }
}

