/*
 * Decompiled with CFR 0.152.
 */
package carbonchat.libs.ninja.egg82.messenger.handler;

import carbonchat.libs.ninja.egg82.messenger.core.Pair;
import carbonchat.libs.ninja.egg82.messenger.handler.AbstractMessagingHandler;
import carbonchat.libs.ninja.egg82.messenger.handler.MessagingHandler;
import carbonchat.libs.ninja.egg82.messenger.packets.MultiPacket;
import carbonchat.libs.ninja.egg82.messenger.packets.Packet;
import carbonchat.libs.ninja.egg82.messenger.services.CollectionProvider;
import carbonchat.libs.ninja.egg82.messenger.services.PacketService;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessagingHandlerImpl
extends AbstractMessagingHandler
implements MessagingHandler {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final List<AbstractMessagingHandler> handlers = new CopyOnWriteArrayList<AbstractMessagingHandler>();

    public MessagingHandlerImpl(@NotNull PacketService packetService) {
        super(packetService);
    }

    public void addHandler(@NotNull AbstractMessagingHandler handler) {
        this.handlers.add(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handlePacket(@NotNull UUID messageId, @NotNull String fromService, @NotNull Packet packet) {
        if (CollectionProvider.isDuplicateMessage(messageId)) {
            return;
        }
        try {
            if (!this.handlePacket(packet)) {
                this.logger.warn("Did not handle packet: " + packet.getClass().getName());
            }
        }
        catch (Exception ex) {
            this.logger.error(ex.getClass().getName() + ": " + ex.getMessage(), (Throwable)ex);
        }
        finally {
            if (this.packetService.hasRedundancy()) {
                this.packetService.repeatPacket(messageId, packet, fromService);
            }
        }
    }

    @Override
    public void flushPacketBuffer(@NotNull UUID forServer) {
        CollectionProvider.getPacketProcessingQueue().computeIfPresent(forServer, (k, v) -> {
            for (Pair p : v) {
                this.handlePacket((UUID)p.getT1(), "", (Packet)p.getT2());
            }
            return null;
        });
    }

    @Override
    protected boolean handlePacket(@NotNull Packet packet) {
        if (packet instanceof MultiPacket) {
            this.handleMulti((MultiPacket)packet);
            return true;
        }
        for (AbstractMessagingHandler handler : this.handlers) {
            if (!handler.handlePacket(packet)) continue;
            return true;
        }
        return false;
    }

    private void handleMulti(@NotNull MultiPacket packet) {
        for (Packet p : packet.getPackets()) {
            if (this.handlePacket(p)) continue;
            this.logger.warn("Did not handle packet: " + packet.getClass().getName());
        }
    }
}

