/*
 * Decompiled with CFR 0.152.
 */
package carbonchat.libs.ninja.egg82.messenger.packets;

import carbonchat.libs.ninja.egg82.messenger.packets.Packet;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPacket
implements Packet {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final UUID sender;

    protected AbstractPacket(@NotNull UUID sender) {
        this.sender = sender;
    }

    @Override
    @NotNull
    public UUID getSender() {
        return this.sender;
    }

    protected final int readVarInt(@NotNull ByteBuf input) {
        return this.readVarInt(input, 5);
    }

    protected final int readVarInt(@NotNull ByteBuf input, int maxBytes) {
        byte in;
        int out = 0;
        int bytes = 0;
        do {
            in = input.readByte();
            out |= (in & 0x7F) << bytes++ * 7;
            if (bytes <= maxBytes) continue;
            throw new RuntimeException("VarInt too big");
        } while ((in & 0x80) == 128);
        return out;
    }

    protected final void writeVarInt(int value, @NotNull ByteBuf output) {
        do {
            int part = value & 0x7F;
            if ((value >>>= 7) != 0) {
                part |= 0x80;
            }
            output.writeByte((int)((byte)part));
        } while (value != 0);
    }

    protected final int readVarShort(@NotNull ByteBuf buf) {
        int low = buf.readShort() & 0xFFFF;
        int high = 0;
        if ((low & 0x8000) != 0) {
            low &= Short.MAX_VALUE;
            high = buf.readByte() & 0xFF;
        }
        return (high & 0xFF) << 15 | low;
    }

    protected final void writeVarShort(int toWrite, @NotNull ByteBuf buf) {
        int low = toWrite & Short.MAX_VALUE;
        int high = (toWrite & 0x7F8000) >> 15;
        if (high != 0) {
            low |= 0x8000;
        }
        buf.writeShort((int)((short)low));
        if (high != 0) {
            buf.writeByte((int)((byte)high));
        }
    }

    @NotNull
    protected final UUID readUUID(@NotNull ByteBuf input) {
        return new UUID(input.readLong(), input.readLong());
    }

    protected final void writeUUID(@NotNull UUID value, @NotNull ByteBuf output) {
        output.writeLong(value.getMostSignificantBits());
        output.writeLong(value.getLeastSignificantBits());
    }

    @NotNull
    protected final String readString(@NotNull ByteBuf buf) {
        int len = this.readVarInt(buf);
        if (len > Short.MAX_VALUE) {
            throw new RuntimeException(String.format("Cannot receive string longer than Short.MAX_VALUE (got %s characters)", len));
        }
        byte[] b = new byte[len];
        buf.readBytes(b);
        return new String(b, StandardCharsets.UTF_8);
    }

    protected final void writeString(@NotNull String s, @NotNull ByteBuf buf) {
        if (s.length() > Short.MAX_VALUE) {
            throw new RuntimeException(String.format("Cannot send string longer than Short.MAX_VALUE (got %s characters)", s.length()));
        }
        byte[] b = s.getBytes(StandardCharsets.UTF_8);
        this.writeVarInt(b.length, buf);
        buf.writeBytes(b);
    }

    @Override
    public boolean verifyFullRead(@NotNull ByteBuf buffer) {
        if (buffer.readableBytes() > 0) {
            this.logger.warn(buffer.readableBytes() + " bytes remain in the packet ByteBuf after being parsed.");
            this.printBytes(buffer);
            return false;
        }
        return true;
    }

    protected final void printBytes(@NotNull ByteBuf buffer) {
        StringBuilder sb = new StringBuilder();
        sb.append('\n');
        sb.append("-- Begin Packet --");
        sb.append('\n');
        sb.append("Type: ").append(this.getClass().getName());
        sb.append('\n');
        sb.append("Bytes:");
        sb.append('\n');
        int index = buffer.readerIndex();
        buffer.readerIndex(0);
        while (buffer.readableBytes() > 0) {
            sb.append(String.format("0x%02X ", buffer.readByte()));
        }
        sb.append('\n');
        buffer.readerIndex(0);
        while (buffer.readableBytes() > 0) {
            sb.append(String.format("%8s ", Integer.toBinaryString(buffer.readByte() & 0xFF)).replace(' ', '0')).append(' ');
        }
        sb.append('\n');
        buffer.readerIndex(0);
        while (buffer.readableBytes() > 0) {
            sb.append(buffer.readByte()).append(' ');
        }
        buffer.readerIndex(index);
        sb.append('\n');
        sb.append("-- End Packet --");
        this.logger.info(sb.toString());
    }
}

