/*
 * Decompiled with CFR 0.152.
 */
package carbonchat.libs.ninja.egg82.messenger.packets;

import carbonchat.libs.ninja.egg82.messenger.PacketManager;
import carbonchat.libs.ninja.egg82.messenger.packets.AbstractPacket;
import carbonchat.libs.ninja.egg82.messenger.packets.Packet;
import carbonchat.libs.ninja.egg82.messenger.utils.UUIDUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public class MultiPacket
extends AbstractPacket {
    private static final ByteBufAllocator alloc = PooledByteBufAllocator.DEFAULT;
    private Set<Packet> packets = new LinkedHashSet<Packet>();

    public MultiPacket(@NotNull UUID sender, @NotNull ByteBuf data) {
        super(sender);
        this.read(data);
    }

    public MultiPacket() {
        super(UUIDUtil.EMPTY_UUID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(@NotNull ByteBuf buffer) {
        byte nextPacket;
        this.packets.clear();
        while (buffer.readableBytes() > 0 && (nextPacket = buffer.readByte()) != 0) {
            int packetLen = buffer.readInt();
            ByteBuf packetBuf = alloc.buffer(packetLen, packetLen);
            try {
                buffer.readBytes(packetBuf);
                try {
                    Object packet = PacketManager.read(nextPacket, this.sender, packetBuf);
                    if (packet == null) {
                        this.logger.warn("Received packet ID that doesn't exist: " + nextPacket);
                        continue;
                    }
                    if (!packet.verifyFullRead(packetBuf)) continue;
                    this.packets.add((Packet)packet);
                }
                catch (Exception ex) {
                    Class<? extends Packet> clazz = PacketManager.getPacket(nextPacket);
                    this.logger.error("Could not instantiate packet" + (clazz != null ? clazz.getName() : "null") + ".", (Throwable)ex);
                }
            }
            finally {
                packetBuf.release();
            }
        }
    }

    @Override
    public void write(@NotNull ByteBuf buffer) {
        if (this.packets.isEmpty()) {
            buffer.writeByte(0);
            return;
        }
        for (Packet packet : this.packets) {
            if (packet == null) continue;
            buffer.writeByte(PacketManager.getId(packet.getClass()));
            int start = buffer.writerIndex();
            buffer.writeInt(0);
            packet.write(buffer);
            buffer.setInt(start, buffer.writerIndex() - start - 4);
        }
        buffer.writeByte(0);
    }

    @NotNull
    public @NotNull Set<@NotNull Packet> getPackets() {
        return this.packets;
    }

    public void setPackets(@NotNull @NotNull Set<@NotNull Packet> packets) {
        this.packets = packets;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MultiPacket)) {
            return false;
        }
        MultiPacket that = (MultiPacket)o;
        return this.packets.equals(that.packets);
    }

    public int hashCode() {
        return Objects.hash(this.packets);
    }

    public String toString() {
        return "MultiPacket{packets=" + this.packets + "}";
    }
}

