/*
 * Decompiled with CFR 0.152.
 */
package carbonchat.libs.ninja.egg82.messenger.packets.server;

import carbonchat.libs.ninja.egg82.messenger.packets.AbstractPacket;
import carbonchat.libs.ninja.egg82.messenger.utils.UUIDUtil;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public class InitializationPacket
extends AbstractPacket {
    private UUID server;
    private byte packetVersion;

    public InitializationPacket(@NotNull UUID sender, @NotNull ByteBuf data) {
        super(sender);
        this.read(data);
    }

    public InitializationPacket() {
        super(UUIDUtil.EMPTY_UUID);
    }

    public InitializationPacket(@NotNull UUID server, byte protocolVersion) {
        super(UUIDUtil.EMPTY_UUID);
        this.server = server;
        this.packetVersion = protocolVersion;
    }

    @Override
    public void read(@NotNull ByteBuf buffer) {
        this.server = this.readUUID(buffer);
        this.packetVersion = buffer.readByte();
    }

    @Override
    public void write(@NotNull ByteBuf buffer) {
        this.writeUUID(this.server, buffer);
        buffer.writeByte((int)this.packetVersion);
    }

    @NotNull
    public UUID getServer() {
        return this.server;
    }

    public void setServer(@NotNull UUID server) {
        this.server = server;
    }

    public byte getPacketVersion() {
        return this.packetVersion;
    }

    public void setPacketVersion(byte packetVersion) {
        this.packetVersion = packetVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InitializationPacket)) {
            return false;
        }
        InitializationPacket that = (InitializationPacket)o;
        return this.packetVersion == that.packetVersion && this.server.equals(that.server);
    }

    public int hashCode() {
        return Objects.hash(this.server, this.packetVersion);
    }

    public String toString() {
        return "InitializationPacket{server=" + this.server + ", packetVersion=" + this.packetVersion + ", sender=" + this.sender + "}";
    }
}

