/*
 * Decompiled with CFR 0.152.
 */
package carbonchat.libs.ninja.egg82.messenger.packets.server;

import carbonchat.libs.ninja.egg82.messenger.packets.AbstractPacket;
import carbonchat.libs.ninja.egg82.messenger.utils.UUIDUtil;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public class KeepAlivePacket
extends AbstractPacket {
    private UUID server;

    public KeepAlivePacket(@NotNull UUID sender, @NotNull ByteBuf data) {
        super(sender);
        this.read(data);
    }

    public KeepAlivePacket() {
        super(UUIDUtil.EMPTY_UUID);
    }

    public KeepAlivePacket(@NotNull UUID server) {
        super(UUIDUtil.EMPTY_UUID);
        this.server = server;
    }

    @Override
    public void read(@NotNull ByteBuf buffer) {
        this.server = this.readUUID(buffer);
    }

    @Override
    public void write(@NotNull ByteBuf buffer) {
        this.writeUUID(this.server, buffer);
    }

    @NotNull
    public UUID getServer() {
        return this.server;
    }

    public void setServer(@NotNull UUID server) {
        this.server = server;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KeepAlivePacket)) {
            return false;
        }
        KeepAlivePacket that = (KeepAlivePacket)o;
        return this.server.equals(that.server);
    }

    public int hashCode() {
        return Objects.hash(this.server);
    }

    public String toString() {
        return "KeepAlivePacket{server=" + this.server + ", sender=" + this.sender + "}";
    }
}

