/*
 * Decompiled with CFR 0.152.
 */
package carbonchat.libs.ninja.egg82.messenger.packets.server;

import carbonchat.libs.ninja.egg82.messenger.packets.AbstractPacket;
import carbonchat.libs.ninja.egg82.messenger.utils.UUIDUtil;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public class PacketVersionPacket
extends AbstractPacket {
    private UUID intendedRecipient;
    private UUID server;
    private byte packetVersion;

    public PacketVersionPacket(@NotNull UUID sender, @NotNull ByteBuf data) {
        super(sender);
        this.read(data);
    }

    public PacketVersionPacket() {
        super(UUIDUtil.EMPTY_UUID);
    }

    public PacketVersionPacket(@NotNull UUID intendedRecipient, @NotNull UUID server, byte protocolVersion) {
        super(UUIDUtil.EMPTY_UUID);
        this.intendedRecipient = intendedRecipient;
        this.server = server;
        this.packetVersion = protocolVersion;
    }

    @Override
    public void read(@NotNull ByteBuf buffer) {
        this.intendedRecipient = this.readUUID(buffer);
        this.server = this.readUUID(buffer);
        this.packetVersion = buffer.readByte();
    }

    @Override
    public void write(@NotNull ByteBuf buffer) {
        this.writeUUID(this.intendedRecipient, buffer);
        this.writeUUID(this.server, buffer);
        buffer.writeByte((int)this.packetVersion);
    }

    @NotNull
    public UUID getIntendedRecipient() {
        return this.intendedRecipient;
    }

    public void setIntendedRecipient(@NotNull UUID intendedRecipient) {
        this.intendedRecipient = intendedRecipient;
    }

    @NotNull
    public UUID getServer() {
        return this.server;
    }

    public void setServer(@NotNull UUID server) {
        this.server = server;
    }

    public byte getPacketVersion() {
        return this.packetVersion;
    }

    public void setPacketVersion(byte packetVersion) {
        this.packetVersion = packetVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PacketVersionPacket)) {
            return false;
        }
        PacketVersionPacket that = (PacketVersionPacket)o;
        return this.packetVersion == that.packetVersion && this.intendedRecipient.equals(that.intendedRecipient) && this.server.equals(that.server);
    }

    public int hashCode() {
        return Objects.hash(this.intendedRecipient, this.server, this.packetVersion);
    }

    public String toString() {
        return "PacketVersionPacket{sender=" + this.sender + ", intendedRecipient=" + this.intendedRecipient + ", server=" + this.server + ", packetVersion=" + this.packetVersion + "}";
    }
}

