/*
 * Decompiled with CFR 0.152.
 */
package carbonchat.libs.ninja.egg82.messenger.packets.server;

import carbonchat.libs.ninja.egg82.messenger.packets.AbstractPacket;
import carbonchat.libs.ninja.egg82.messenger.utils.UUIDUtil;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public class PacketVersionRequestPacket
extends AbstractPacket {
    private UUID intendedRecipient;
    private UUID server;

    public PacketVersionRequestPacket(@NotNull UUID sender, @NotNull ByteBuf data) {
        super(sender);
        this.read(data);
    }

    public PacketVersionRequestPacket() {
        super(UUIDUtil.EMPTY_UUID);
    }

    public PacketVersionRequestPacket(@NotNull UUID intendedRecipient, @NotNull UUID server) {
        super(UUIDUtil.EMPTY_UUID);
        this.intendedRecipient = intendedRecipient;
        this.server = server;
    }

    @Override
    public void read(@NotNull ByteBuf buffer) {
        this.intendedRecipient = this.readUUID(buffer);
        this.server = this.readUUID(buffer);
    }

    @Override
    public void write(@NotNull ByteBuf buffer) {
        this.writeUUID(this.intendedRecipient, buffer);
        this.writeUUID(this.server, buffer);
    }

    @NotNull
    public UUID getIntendedRecipient() {
        return this.intendedRecipient;
    }

    public void setIntendedRecipient(@NotNull UUID intendedRecipient) {
        this.intendedRecipient = intendedRecipient;
    }

    @NotNull
    public UUID getServer() {
        return this.server;
    }

    public void setServer(@NotNull UUID server) {
        this.server = server;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PacketVersionRequestPacket)) {
            return false;
        }
        PacketVersionRequestPacket that = (PacketVersionRequestPacket)o;
        return this.intendedRecipient.equals(that.intendedRecipient) && this.server.equals(that.server);
    }

    public int hashCode() {
        return Objects.hash(this.intendedRecipient, this.server);
    }

    public String toString() {
        return "PacketVersionRequestPacket{sender=" + this.sender + ", intendedRecipient=" + this.intendedRecipient + ", server=" + this.server + "}";
    }
}

