/*
 * Decompiled with CFR 0.152.
 */
package carbonchat.libs.ninja.egg82.messenger.services;

import carbonchat.libs.com.github.benmanes.caffeine.cache.Cache;
import carbonchat.libs.com.github.benmanes.caffeine.cache.Caffeine;
import carbonchat.libs.ninja.egg82.messenger.core.Pair;
import carbonchat.libs.ninja.egg82.messenger.packets.Packet;
import it.unimi.dsi.fastutil.objects.Object2ByteArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ByteMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CollectionProvider {
    private static final Object2ByteMap<UUID> serverVersions = new Object2ByteArrayMap();
    private static final @NotNull Cache<UUID, @Nullable Boolean> messageCache = Caffeine.newBuilder().expireAfterWrite(2L, TimeUnit.MINUTES).expireAfterAccess(30L, TimeUnit.SECONDS).build();
    private static final ConcurrentMap<UUID, @Nullable List<@NotNull Pair<@NotNull UUID, @NotNull Packet>>> packetProcessingQueue = new ConcurrentHashMap<UUID, List<Pair<UUID, Packet>>>();

    private CollectionProvider() {
    }

    public static Object2ByteMap<UUID> getServerVersions() {
        return serverVersions;
    }

    public static @NotNull Cache<UUID, @Nullable Boolean> getMessageCache() {
        return messageCache;
    }

    public static boolean isDuplicateMessage(@NotNull UUID messageId) {
        AtomicBoolean retVal = new AtomicBoolean(true);
        messageCache.get((Object)messageId, k -> {
            retVal.set(false);
            return Boolean.FALSE;
        });
        return retVal.get();
    }

    @NotNull
    public static @NotNull ConcurrentMap<UUID, @Nullable List<@NotNull Pair<@NotNull UUID, @NotNull Packet>>> getPacketProcessingQueue() {
        return packetProcessingQueue;
    }
}

