/*
 * Decompiled with CFR 0.152.
 */
package carbonchat.libs.ninja.egg82.messenger.services;

import carbonchat.libs.ninja.egg82.messenger.MessagingService;
import carbonchat.libs.ninja.egg82.messenger.core.DoubleBuffer;
import carbonchat.libs.ninja.egg82.messenger.packets.MultiPacket;
import carbonchat.libs.ninja.egg82.messenger.packets.Packet;
import carbonchat.libs.ninja.egg82.messenger.services.CollectionProvider;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PacketService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ExecutorService workPool;
    private final boolean redundancy;
    private final byte packetVersion;
    private final List<MessagingService> messengers = new CopyOnWriteArrayList<MessagingService>();
    private final ReadWriteLock servicesLock = new ReentrantReadWriteLock();
    private final DoubleBuffer<Packet> packetQueue = new DoubleBuffer();
    private final AtomicBoolean requiresSending = new AtomicBoolean(false);
    private final AtomicInteger currentIndex = new AtomicInteger(-1);

    public PacketService(int poolSize, boolean redundancy, byte packetVersion) {
        this.workPool = Executors.newFixedThreadPool(Math.max(poolSize, 1));
        this.redundancy = redundancy;
        this.packetVersion = packetVersion;
    }

    public boolean hasRedundancy() {
        return this.redundancy;
    }

    public byte getPacketVersion() {
        return this.packetVersion;
    }

    public void shutdown() {
        this.workPool.shutdown();
        try {
            if (!this.workPool.awaitTermination(4L, TimeUnit.SECONDS)) {
                this.workPool.shutdownNow();
            }
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addMessenger(@NotNull MessagingService service) {
        this.servicesLock.writeLock().lock();
        try {
            for (MessagingService m : this.messengers) {
                if (!m.getName().equals(service.getName())) continue;
                boolean bl = false;
                return bl;
            }
            this.messengers.add(service);
            boolean bl = true;
            return bl;
        }
        finally {
            this.servicesLock.writeLock().unlock();
        }
    }

    public boolean removeMessenger(@NotNull MessagingService service) {
        return this.removeMessenger(service.getName());
    }

    public boolean removeMessenger(@NotNull String serviceName) {
        this.servicesLock.writeLock().lock();
        try {
            boolean bl = this.messengers.removeIf(s -> s.getName().equals(serviceName));
            return bl;
        }
        finally {
            this.servicesLock.writeLock().unlock();
        }
    }

    public void queuePackets(@NotNull @NotNull Collection<@NotNull Packet> packets) {
        this.packetQueue.getWriteBuffer().addAll(packets);
        this.requiresSending.set(true);
    }

    public void queuePackets(Packet ... packets) {
        for (Packet packet : packets) {
            this.packetQueue.getWriteBuffer().add(packet);
        }
        this.requiresSending.set(true);
    }

    public void queuePacket(@NotNull Packet packet) {
        this.packetQueue.getWriteBuffer().add(packet);
        this.requiresSending.set(true);
    }

    public void repeatPacket(@NotNull UUID messageId, @NotNull Packet packet, @NotNull String fromServiceName) {
        this.sendPacket(messageId, packet, fromServiceName);
    }

    public boolean flushQueue() {
        if (!this.requiresSending.compareAndSet(true, false)) {
            return false;
        }
        this.packetQueue.swapBuffers();
        UUID messageId = UUID.randomUUID();
        CollectionProvider.getMessageCache().put((Object)messageId, (Object)Boolean.TRUE);
        if (this.packetQueue.getReadBuffer().size() > 1) {
            Packet packet;
            MultiPacket multi = new MultiPacket();
            while ((packet = this.packetQueue.getReadBuffer().poll()) != null) {
                if (multi.getPackets().add(packet)) continue;
                this.logger.warn("Skipping duplicate packet " + packet.getClass().getSimpleName());
            }
            if (!multi.getPackets().isEmpty()) {
                this.sendPacket(messageId, multi, null);
            }
        } else {
            Packet packet = this.packetQueue.getReadBuffer().poll();
            if (packet != null) {
                this.sendPacket(messageId, packet, null);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPacket(@NotNull UUID messageId, @NotNull Packet packet, @Nullable String fromServiceName) {
        if (this.redundancy) {
            this.servicesLock.readLock().lock();
            try {
                for (MessagingService messenger : this.messengers) {
                    if (messenger.getName().equals(fromServiceName)) continue;
                    this.workPool.execute(() -> {
                        try {
                            messenger.sendPacket(messageId, packet);
                        }
                        catch (IOException | TimeoutException ex) {
                            this.logger.warn("Could not broadcast packet " + packet.getClass().getSimpleName() + " through " + messenger.getName(), (Throwable)ex);
                        }
                    });
                }
            }
            finally {
                this.servicesLock.readLock().unlock();
            }
        }
        if (fromServiceName != null) {
            return;
        }
        this.servicesLock.readLock().lock();
        try {
            int index;
            int initialIndex = index = this.getNextService();
            boolean sent = false;
            while (true) {
                MessagingService messenger = this.messengers.get(index);
                try {
                    messenger.sendPacket(messageId, packet);
                    sent = true;
                }
                catch (IOException | TimeoutException ex) {
                    this.logger.warn("Could not broadcast packet " + packet.getClass().getSimpleName() + " through " + messenger.getName(), (Throwable)ex);
                    if ((index = this.getNextService()) != initialIndex) continue;
                }
                break;
            }
            if (!sent) {
                this.logger.error("Could not broadcast packet " + packet.getClass().getSimpleName() + " through any available messaging service.");
            }
        }
        finally {
            this.servicesLock.readLock().unlock();
        }
    }

    private int getNextService() {
        return this.currentIndex.updateAndGet(v -> {
            if (v >= this.messengers.size() - 1) {
                return 0;
            }
            return v + 1;
        });
    }
}

