/*
 * Decompiled with CFR 0.152.
 */
package carbonchat.libs.org.incendo.cloud.minecraft.extras.parser;

import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Locale;
import java.util.regex.Pattern;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.apiguardian.api.API;
import org.incendo.cloud.caption.CaptionVariable;
import org.incendo.cloud.caption.StandardCaptionKeys;
import org.incendo.cloud.component.CommandComponent;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.context.CommandInput;
import org.incendo.cloud.exception.parsing.ParserException;
import org.incendo.cloud.parser.ArgumentParseResult;
import org.incendo.cloud.parser.ArgumentParser;
import org.incendo.cloud.parser.ParserContributor;
import org.incendo.cloud.parser.ParserDescriptor;
import org.incendo.cloud.parser.ParserRegistry;
import org.incendo.cloud.suggestion.BlockingSuggestionProvider;
import org.incendo.cloud.type.tuple.Pair;

public final class TextColorParser<C>
implements ArgumentParser<C, TextColor>,
BlockingSuggestionProvider.Strings<C> {
    private static final Pattern LEGACY_PREDICATE = Pattern.compile("&[0-9a-fA-F]");
    private static final Pattern HEX_PREDICATE = Pattern.compile("#?([a-fA-F0-9]{1,6})");
    private static final Collection<Pair<Character, NamedTextColor>> COLORS = Arrays.asList(Pair.of((Object)Character.valueOf('0'), (Object)NamedTextColor.BLACK), Pair.of((Object)Character.valueOf('1'), (Object)NamedTextColor.DARK_BLUE), Pair.of((Object)Character.valueOf('2'), (Object)NamedTextColor.DARK_GREEN), Pair.of((Object)Character.valueOf('3'), (Object)NamedTextColor.DARK_AQUA), Pair.of((Object)Character.valueOf('4'), (Object)NamedTextColor.DARK_RED), Pair.of((Object)Character.valueOf('5'), (Object)NamedTextColor.DARK_PURPLE), Pair.of((Object)Character.valueOf('6'), (Object)NamedTextColor.GOLD), Pair.of((Object)Character.valueOf('7'), (Object)NamedTextColor.GRAY), Pair.of((Object)Character.valueOf('8'), (Object)NamedTextColor.DARK_GRAY), Pair.of((Object)Character.valueOf('9'), (Object)NamedTextColor.BLUE), Pair.of((Object)Character.valueOf('a'), (Object)NamedTextColor.GREEN), Pair.of((Object)Character.valueOf('b'), (Object)NamedTextColor.AQUA), Pair.of((Object)Character.valueOf('c'), (Object)NamedTextColor.RED), Pair.of((Object)Character.valueOf('d'), (Object)NamedTextColor.LIGHT_PURPLE), Pair.of((Object)Character.valueOf('e'), (Object)NamedTextColor.YELLOW), Pair.of((Object)Character.valueOf('f'), (Object)NamedTextColor.WHITE));

    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C> @NonNull ParserDescriptor<C, TextColor> textColorParser() {
        return ParserDescriptor.of(new TextColorParser<C>(), TextColor.class);
    }

    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C> // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull CommandComponent.Builder<C, TextColor> textColorComponent() {
        return CommandComponent.builder().parser(TextColorParser.textColorParser());
    }

    public @NonNull ArgumentParseResult<@NonNull TextColor> parse(@NonNull CommandContext<@NonNull C> commandContext, @NonNull CommandInput commandInput) {
        String input = commandInput.peekString();
        if (LEGACY_PREDICATE.matcher(input).matches()) {
            commandInput.moveCursor(1);
            char code = Character.toLowerCase(commandInput.read());
            for (Pair<Character, NamedTextColor> pair : COLORS) {
                if (((Character)pair.first()).charValue() != code) continue;
                return ArgumentParseResult.success((Object)((TextColor)pair.second()));
            }
            commandInput.moveCursor(-2);
        }
        for (Pair<Character, NamedTextColor> pair : COLORS) {
            if (!((NamedTextColor)pair.second()).toString().equalsIgnoreCase(commandInput.peekString())) continue;
            commandInput.readString();
            return ArgumentParseResult.success((Object)((TextColor)pair.second()));
        }
        if (HEX_PREDICATE.matcher(commandInput.peekString()).matches()) {
            if (commandInput.peek() == '#') {
                commandInput.moveCursor(1);
            }
            return ArgumentParseResult.success((Object)TextColor.color((int)commandInput.readInteger(16)));
        }
        return ArgumentParseResult.failure((Throwable)((Object)new TextColorParseException(commandContext, input)));
    }

    public @NonNull Iterable<@NonNull String> stringSuggestions(@NonNull CommandContext<C> commandContext, @NonNull CommandInput input) {
        LinkedList<String> suggestions = new LinkedList<String>();
        String token = input.readString();
        String tokenLower = token.toLowerCase(Locale.ROOT);
        boolean matchedName = false;
        for (String name : NamedTextColor.NAMES.keys()) {
            if (name.contains(tokenLower)) {
                matchedName = true;
            }
            suggestions.add(name);
        }
        if (!matchedName && !token.isEmpty() && (token.equals("#") || HEX_PREDICATE.matcher(token).matches() && token.length() < (token.startsWith("#") ? 7 : 6))) {
            char c;
            for (c = 'a'; c <= 'f'; c = (char)(c + '\u0001')) {
                suggestions.add(String.format("%s%c", token, Character.valueOf(c)));
            }
            for (c = '0'; c <= '9'; c = (char)(c + '\u0001')) {
                suggestions.add(String.format("%s%c", token, Character.valueOf(c)));
            }
        }
        return suggestions;
    }

    private static final class TextColorParseException
    extends ParserException {
        private TextColorParseException(@NonNull CommandContext<?> commandContext, @NonNull String input) {
            super(TextColorParser.class, commandContext, StandardCaptionKeys.ARGUMENT_PARSE_FAILURE_COLOR, new CaptionVariable[]{CaptionVariable.of((String)"input", (String)input)});
        }
    }

    @API(status=API.Status.INTERNAL)
    public static final class Contributor
    implements ParserContributor {
        public <C> void contribute(ParserRegistry<C> registry) {
            try {
                registry.registerParser(TextColorParser.textColorParser());
            }
            catch (Exception | LinkageError throwable) {
                // empty catch block
            }
        }
    }
}

