/*
 * Decompiled with CFR 0.152.
 */
package carbonchat.libs.org.spongepowered.configurate.loader;

import carbonchat.libs.org.checkerframework.checker.nullness.qual.Nullable;
import carbonchat.libs.org.spongepowered.configurate.ConfigurationNode;
import carbonchat.libs.org.spongepowered.configurate.serialize.SerializationException;
import java.util.Objects;
import java.util.regex.Pattern;
import net.kyori.option.Option;
import net.kyori.option.value.ValueSource;

final class ValueSources {
    private ValueSources() {
    }

    public static ValueSource node(ConfigurationNode node) {
        return new Node(Objects.requireNonNull(node, "node"));
    }

    static final class Node
    implements ValueSource {
        private static final Pattern PATH_SPLIT = Pattern.compile("[:/]");
        private final ConfigurationNode source;

        Node(ConfigurationNode source) {
            this.source = source;
        }

        public <T> @Nullable T value(Option<T> option) {
            String[] path = PATH_SPLIT.split(option.id(), -1);
            try {
                return (T)this.source.node(path).get(option.valueType().type());
            }
            catch (SerializationException ex) {
                throw new IllegalArgumentException(ex);
            }
        }
    }
}

