/*
 * Decompiled with CFR 0.152.
 */
package carbonchat.libs.org.spongepowered.configurate.serialize;

import carbonchat.libs.org.spongepowered.configurate.serialize.CoercionFailedException;
import carbonchat.libs.org.spongepowered.configurate.serialize.ScalarSerializer;
import carbonchat.libs.org.spongepowered.configurate.serialize.SerializationException;
import carbonchat.libs.org.spongepowered.configurate.serialize.TypeSerializer;
import java.util.Locale;
import java.util.function.BiFunction;

final class NumericSerializers {
    private static final float EPSILON = Float.MIN_NORMAL;
    static final ScalarSerializer<Float> FLOAT = TypeSerializer.of(Float.class, (v, pass) -> {
        if (pass.test(Double.class)) {
            return v.doubleValue();
        }
        return v.toString();
    }, v -> {
        if (v instanceof Number) {
            double d = ((Number)v).doubleValue();
            if (!NumericSerializers.canRepresentDoubleAsFloat(d)) {
                throw new SerializationException("Value " + d + " cannot be represented as a float without significant loss of precision");
            }
            return Float.valueOf((float)d);
        }
        if (v instanceof CharSequence) {
            String value = v.toString();
            if (value.endsWith("f") || value.endsWith("F")) {
                value = value.substring(0, value.length() - 1);
            }
            try {
                return Float.valueOf(Float.parseFloat(value));
            }
            catch (NumberFormatException ex) {
                throw new SerializationException(ex);
            }
        }
        throw new CoercionFailedException(v, "float");
    });
    static final ScalarSerializer<Double> DOUBLE = TypeSerializer.of(Double.class, (v, pass) -> v.toString(), v -> {
        if (v instanceof Number) {
            return ((Number)v).doubleValue();
        }
        if (v instanceof CharSequence) {
            String value = v.toString();
            if (value.endsWith("d") || value.endsWith("D")) {
                value = value.substring(0, value.length() - 1);
            }
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException ex) {
                throw new SerializationException(ex);
            }
        }
        throw new CoercionFailedException(v, "double");
    });
    static final ScalarSerializer<Byte> BYTE = TypeSerializer.of(Byte.class, (v, pass) -> {
        if (pass.test(Short.class)) {
            return v.shortValue();
        }
        if (pass.test(Integer.class)) {
            return v.intValue();
        }
        if (pass.test(Double.class)) {
            return v.doubleValue();
        }
        if (pass.test(Long.class)) {
            return v.longValue();
        }
        return v.toString();
    }, value -> {
        if (value instanceof Float || value instanceof Double) {
            double absVal = Math.abs(((Number)value).doubleValue());
            if (absVal - Math.floor(absVal) < 1.1754943508222875E-38 && absVal <= 127.0) {
                return (byte)absVal;
            }
            throw new CoercionFailedException(value, "byte");
        }
        if (value instanceof Number) {
            long full = ((Number)value).longValue();
            if (full > 127L || full < -128L) {
                throw new SerializationException("Value " + full + " is out of range for a byte ([" + -128 + "," + 127 + "])");
            }
            return (byte)full;
        }
        if (value instanceof CharSequence) {
            return NumericSerializers.parseNumber(value.toString(), Byte::parseByte, Byte::parseByte, "b");
        }
        throw new CoercionFailedException(value, "byte");
    });
    static final ScalarSerializer<Short> SHORT = TypeSerializer.of(Short.class, (v, pass) -> {
        if (pass.test(Integer.class)) {
            return v.intValue();
        }
        if (pass.test(Long.class)) {
            return v.longValue();
        }
        if (pass.test(Double.class)) {
            return v.doubleValue();
        }
        return v.toString();
    }, value -> {
        if (value instanceof Float || value instanceof Double) {
            double absVal = Math.abs(((Number)value).doubleValue());
            if (absVal - Math.floor(absVal) < 1.1754943508222875E-38 && absVal <= 32767.0) {
                return (short)absVal;
            }
            throw new CoercionFailedException(value, "short");
        }
        if (value instanceof Number) {
            long full = ((Number)value).longValue();
            if (full > 32767L || full < -32768L) {
                throw new SerializationException("Value " + full + " is out of range for a short ([" + Short.MIN_VALUE + "," + Short.MAX_VALUE + "])");
            }
            return (short)full;
        }
        if (value instanceof CharSequence) {
            return NumericSerializers.parseNumber(value.toString(), Short::parseShort, Short::parseShort, "s");
        }
        throw new CoercionFailedException(value, "short");
    });
    static final ScalarSerializer<Integer> INTEGER = TypeSerializer.of(Integer.class, (v, pass) -> {
        if (pass.test(Double.class)) {
            return v.doubleValue();
        }
        if (pass.test(Long.class)) {
            return v.longValue();
        }
        return v.toString();
    }, value -> {
        if (value instanceof Float || value instanceof Double) {
            double absVal = Math.abs(((Number)value).doubleValue());
            if (absVal - Math.floor(absVal) < 1.1754943508222875E-38 && absVal <= 2.147483647E9) {
                return (int)absVal;
            }
            throw new CoercionFailedException(value, "int");
        }
        if (value instanceof Number) {
            long full = ((Number)value).longValue();
            if (full > Integer.MAX_VALUE || full < Integer.MIN_VALUE) {
                throw new SerializationException("Value " + full + " is out of range for an integer ([" + Integer.MIN_VALUE + "," + Integer.MAX_VALUE + "])");
            }
            return (int)full;
        }
        if (value instanceof CharSequence) {
            return NumericSerializers.parseNumber(value.toString(), Integer::parseInt, Integer::parseUnsignedInt, "i");
        }
        throw new CoercionFailedException(value, "int");
    });
    static final ScalarSerializer<Long> LONG = TypeSerializer.of(Long.class, (v, pass) -> v.toString(), value -> {
        if (value instanceof Float || value instanceof Double) {
            double absVal = Math.abs(((Number)value).doubleValue());
            if (absVal - Math.floor(absVal) < 1.1754943508222875E-38 && absVal <= 9.223372036854776E18) {
                return (long)absVal;
            }
            throw new CoercionFailedException(value, "long");
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof CharSequence) {
            return NumericSerializers.parseNumber(value.toString(), Long::parseLong, Long::parseUnsignedLong, "l");
        }
        throw new CoercionFailedException(value, "long");
    });

    private NumericSerializers() {
    }

    private static boolean canRepresentDoubleAsFloat(double test) {
        if (test == 0.0 || test == -0.0 || !Double.isFinite(test)) {
            return true;
        }
        int exponent = Math.getExponent(test);
        return exponent >= -126 && exponent <= 127;
    }

    static <T extends Number> T parseNumber(String input, BiFunction<String, Integer, T> parseFunc, BiFunction<String, Integer, T> unsignedParseFunc, String suffix) throws SerializationException {
        boolean unsigned = false;
        boolean negative = false;
        int startIdx = 0;
        int endIdx = input.length();
        if (input.endsWith(suffix) || input.endsWith(suffix.toUpperCase(Locale.ROOT))) {
            --endIdx;
        }
        if (endIdx > 0 && input.charAt(endIdx - 1) == 'u') {
            unsigned = true;
            --endIdx;
        }
        if (endIdx > startIdx && input.charAt(startIdx) == '-') {
            if (unsigned) {
                throw new SerializationException("Negative numbers cannot be unsigned! (both - prefix and u suffix were used)");
            }
            negative = true;
            ++startIdx;
        } else if (endIdx > startIdx && input.charAt(startIdx) == '+') {
            ++startIdx;
        }
        int radix = 10;
        if (input.startsWith("0x", startIdx)) {
            radix = 16;
            startIdx += 2;
        } else if (input.length() > startIdx && input.charAt(startIdx) == '#') {
            radix = 16;
            ++startIdx;
        } else if (input.startsWith("0b", startIdx)) {
            radix = 2;
            startIdx += 2;
        }
        input = input.substring(startIdx, endIdx);
        if (negative) {
            input = "-" + input;
        }
        try {
            return (T)((Number)(unsigned ? unsignedParseFunc : parseFunc).apply(input, radix));
        }
        catch (IllegalArgumentException ex) {
            throw new SerializationException(ex);
        }
    }
}

