/*
 * Decompiled with CFR 0.152.
 */
package carbonchat.libs.org.spongepowered.configurate.util;

import carbonchat.libs.org.spongepowered.configurate.util.MapFactory;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;

public final class MapFactories {
    private MapFactories() {
    }

    public static MapFactory unordered() {
        return DefaultFactory.UNORDERED;
    }

    public static MapFactory sorted(Comparator<Object> comparator) {
        return new SortedMapFactory(Objects.requireNonNull(comparator, "comparator"));
    }

    public static MapFactory sortedNatural() {
        return DefaultFactory.SORTED_NATURAL;
    }

    public static MapFactory insertionOrdered() {
        return DefaultFactory.INSERTION_ORDERED;
    }

    private static enum DefaultFactory implements MapFactory
    {
        UNORDERED{

            public <K, V> ConcurrentMap<K, V> create() {
                return new ConcurrentHashMap();
            }
        }
        ,
        SORTED_NATURAL{

            public <K, V> ConcurrentMap<K, V> create() {
                return new ConcurrentSkipListMap();
            }
        }
        ,
        INSERTION_ORDERED{

            @Override
            public <K, V> Map<K, V> create() {
                return new LinkedHashMap();
            }
        };

    }

    private static final class SortedMapFactory
    implements MapFactory {
        private final Comparator<Object> comparator;

        private SortedMapFactory(Comparator<Object> comparator) {
            this.comparator = comparator;
        }

        public <K, V> ConcurrentMap<K, V> create() {
            return new ConcurrentSkipListMap(this.comparator);
        }

        public boolean equals(Object obj) {
            return obj instanceof SortedMapFactory && this.comparator.equals(((SortedMapFactory)obj).comparator);
        }

        public int hashCode() {
            return this.comparator.hashCode();
        }

        public String toString() {
            return "SortedMapFactory{comparator=" + this.comparator + '}';
        }
    }
}

