/*
 * Decompiled with CFR 0.152.
 */
package carbonchat.libs.xyz.jpenilla.gremlin.runtime;

import carbonchat.libs.xyz.jpenilla.gremlin.runtime.DependencyResolver;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.List;
import java.util.stream.Stream;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class DependencyCache {
    private final Path dir;

    public DependencyCache(Path cacheDirectory) {
        this.dir = cacheDirectory;
    }

    public Path cacheDirectory() {
        return this.dir;
    }

    public void cleanup() {
        this.cleanup(1L, ChronoUnit.HOURS);
    }

    public void cleanup(long deleteUnusedFor, TemporalUnit unit) {
        if (!Files.isDirectory(this.dir, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> s = Files.walk(this.dir, new FileVisitOption[0]);){
            for (Path f : s.toList()) {
                long sinceUsed;
                long lastUsed;
                if (!Files.isRegularFile(f, new LinkOption[0]) || !f.getFileName().toString().endsWith(".jar") || (lastUsed = DependencyResolver.lastUsed(f)) == -1L || (sinceUsed = System.currentTimeMillis() - lastUsed) <= Duration.of(deleteUnusedFor, unit).toMillis()) continue;
                Files.delete(f);
                Files.deleteIfExists(DependencyResolver.lastUsedFile(f));
                this.deleteEmptyParents(f);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to clean cache", e);
        }
    }

    private void deleteEmptyParents(Path path) throws IOException {
        List<Path> siblings;
        Path parent = path.getParent();
        if (parent.toAbsolutePath().equals(this.dir.toAbsolutePath())) {
            return;
        }
        try (Stream<Path> st = Files.list(parent);){
            siblings = st.toList();
        }
        if (siblings.isEmpty()) {
            Files.delete(parent);
            this.deleteEmptyParents(parent);
        }
    }
}

