/*
 * Decompiled with CFR 0.152.
 */
package carbonchat.libs.xyz.jpenilla.gremlin.runtime;

import carbonchat.libs.xyz.jpenilla.gremlin.runtime.Dependency;
import carbonchat.libs.xyz.jpenilla.gremlin.runtime.DependencyCache;
import carbonchat.libs.xyz.jpenilla.gremlin.runtime.DependencySet;
import carbonchat.libs.xyz.jpenilla.gremlin.runtime.Extension;
import carbonchat.libs.xyz.jpenilla.gremlin.runtime.JarProcessor;
import carbonchat.libs.xyz.jpenilla.gremlin.runtime.ResolvedDependencySet;
import carbonchat.libs.xyz.jpenilla.gremlin.runtime.logging.GremlinLogger;
import carbonchat.libs.xyz.jpenilla.gremlin.runtime.util.HashResult;
import carbonchat.libs.xyz.jpenilla.gremlin.runtime.util.HashingAlgorithm;
import carbonchat.libs.xyz.jpenilla.gremlin.runtime.util.MultiAlgorithmHasher;
import carbonchat.libs.xyz.jpenilla.gremlin.runtime.util.Util;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class DependencyResolver
implements AutoCloseable {
    private static final MultiAlgorithmHasher MULTI_HASHER = new MultiAlgorithmHasher(HashingAlgorithm.SHA1, HashingAlgorithm.SHA256);
    private static final Pattern UNIQUE_SNAPSHOT = Pattern.compile("(?:.+)-(\\d{8}\\.\\d{6}-\\d+)");
    private static final String USER_AGENT_HEADER = "User-Agent";
    private static final String USER_AGENT = "gremlin";
    private final GremlinLogger logger;
    private final HttpClient client;
    private final Map<String, ClassLoaderIsolatedJarProcessorProvider> isolatedProcessorProviders = new ConcurrentHashMap<String, ClassLoaderIsolatedJarProcessorProvider>();
    private final Map<Thread, Object> resolving = new HashMap<Thread, Object>();
    private volatile boolean closed = false;

    public DependencyResolver(GremlinLogger logger) {
        this.logger = logger;
        this.client = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).build();
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            throw new IllegalStateException("Already closed");
        }
        if (!this.resolving.isEmpty()) {
            throw new IllegalStateException("Cannot close while resolving");
        }
        this.closed = true;
        @Nullable Exception e = null;
        for (ClassLoaderIsolatedJarProcessorProvider provider : this.isolatedProcessorProviders.values()) {
            try {
                provider.loader().close();
            }
            catch (Exception ex) {
                if (e == null) {
                    e = ex;
                    continue;
                }
                e.addSuppressed(ex);
            }
        }
        this.isolatedProcessorProviders.clear();
        if (e != null) {
            throw Util.rethrow(e);
        }
        if (AutoCloseable.class.isInstance(this.client)) {
            try {
                ((AutoCloseable)this.client).close();
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to close HttpClient", ex);
            }
        }
    }

    public ResolvedDependencySet resolve(DependencySet dependencySet, DependencyCache cache) {
        return this.resolve(dependencySet, cache, cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResolvedDependencySet resolve(DependencySet dependencySet, DependencyCache cache, DependencyCache extensionDependencyCache) {
        Object object = this;
        synchronized (object) {
            if (this.closed) {
                throw new IllegalStateException("This " + DependencyResolver.class.getSimpleName() + " has been closed");
            }
            this.resolving.put(Thread.currentThread(), new Object());
        }
        try {
            object = this.resolve_(dependencySet, cache, extensionDependencyCache);
            return object;
        }
        finally {
            DependencyResolver dependencyResolver = this;
            synchronized (dependencyResolver) {
                this.resolving.remove(Thread.currentThread());
            }
        }
    }

    private ResolvedDependencySet resolve_(DependencySet dependencySet, DependencyCache cache, DependencyCache extensionDependencyCache) {
        ConcurrentHashMap resolved = new ConcurrentHashMap();
        AtomicBoolean didWork = new AtomicBoolean(false);
        Runnable doingWork = () -> {
            if (didWork.compareAndSet(false, true)) {
                this.logger.info("Resolving dependencies...");
            }
        };
        ExecutorService executor = this.makeExecutor();
        Map<String, JarProcessor> processors = this.createJarProcessors(dependencySet, executor, extensionDependencyCache, doingWork);
        List<Callable<Void>> tasks = dependencySet.dependencies().stream().map(dep -> () -> {
            try {
                FileWithHashes resolve = this.resolve((Dependency)dep, dependencySet.repositories(), cache, doingWork);
                if (!resolve.path().getFileName().toString().endsWith(".jar")) {
                    resolved.put(dep, resolve.path());
                    return null;
                }
                Path processed = DependencyResolver.processJar(resolve, processors, doingWork);
                resolved.put(dep, processed);
            }
            catch (IOException | IllegalArgumentException e) {
                throw new RuntimeException("Exception resolving " + String.valueOf(dep), e);
            }
            return null;
        }).toList();
        DependencyResolver.executeTasks(executor, tasks);
        Util.shutdownExecutor(executor, TimeUnit.MILLISECONDS, 50L);
        if (didWork.get()) {
            this.logger.info("Done resolving dependencies.");
        }
        return new ResolvedDependencySet(Map.copyOf(resolved));
    }

    private static Path processJar(FileWithHashes resolved, Map<String, JarProcessor> processors, Runnable doingWork) throws IOException {
        Path jarPath;
        Path in = jarPath = resolved.path();
        for (Map.Entry<String, JarProcessor> processorEntry : processors.entrySet()) {
            String extName = processorEntry.getKey();
            JarProcessor processor = processorEntry.getValue();
            String postfix = extName + "-" + DependencyResolver.cacheKey(processor, in, resolved);
            String outputName = jarPath.getFileName().toString().replace(".jar", "-" + postfix + ".jar");
            Path out = jarPath.resolveSibling(outputName);
            if (Files.isRegularFile(out, new LinkOption[0])) {
                DependencyResolver.writeLastUsed(out);
                in = out;
                continue;
            }
            doingWork.run();
            Path outTmp = out.resolveSibling(out.getFileName().toString() + ".tmp");
            Files.deleteIfExists(outTmp);
            processor.process(in, outTmp);
            Files.move(outTmp, out, new CopyOption[0]);
            DependencyResolver.writeLastUsed(out);
            in = out;
        }
        return in;
    }

    private static String cacheKey(JarProcessor processor, Path input, FileWithHashes resolved) throws IOException {
        String inputHash = input.toAbsolutePath().equals(resolved.path().toAbsolutePath()) ? resolved.sha1().asHexString() : HashingAlgorithm.SHA1.hashFile(input).asHexString();
        @Nullable String processorKey = processor.cacheKey();
        if (processorKey == null) {
            return inputHash;
        }
        String processorKeyHash = HashingAlgorithm.SHA1.hashString(processorKey).asHexString();
        return HashingAlgorithm.SHA1.hashString(processorKeyHash + inputHash).asHexString();
    }

    private Map<String, JarProcessor> createJarProcessors(DependencySet dependencySet, ExecutorService executor, DependencyCache extensionDependencyCache, Runnable attemptingDownloadCallback) {
        LinkedHashMap<String, JarProcessor> processors = new LinkedHashMap<String, JarProcessor>();
        for (Map.Entry<String, Extension<?>> entry : dependencySet.extensions().entrySet()) {
            String extName = entry.getKey();
            Extension<Object> ext = entry.getValue();
            @Nullable S state = dependencySet.extensionData(extName);
            if (state == null) continue;
            List<Dependency> deps = Util.sorted(ext.dependencies(state));
            if (deps.isEmpty()) {
                try {
                    Constructor<?> ctr = Class.forName(ext.processorName(), true, ext.getClass().getClassLoader()).getDeclaredConstructors()[0];
                    processors.put(extName, (JarProcessor)ctr.newInstance(state));
                    continue;
                }
                catch (Exception ex) {
                    throw Util.rethrow(ex);
                }
            }
            ClassLoaderIsolatedJarProcessorProvider provider = this.isolatedProcessorProviders.computeIfAbsent(DependencyResolver.isolatedProcessorProviderKey(ext, deps), $ -> {
                CopyOnWriteArrayList<URL> depPaths = new CopyOnWriteArrayList<URL>();
                List<Callable<Void>> tasks = deps.stream().map(dep -> () -> {
                    try {
                        depPaths.add(this.resolve((Dependency)dep, dependencySet.repositories(), extensionDependencyCache, attemptingDownloadCallback).path().toUri().toURL());
                        return null;
                    }
                    catch (IOException ex) {
                        throw Util.rethrow(ex);
                    }
                }).toList();
                DependencyResolver.executeTasks(executor, tasks);
                depPaths.add(Util.classpathUrl(ext.getClass()));
                @Nullable DependencyResolver.1 loader = new URLClassLoader((URL[])depPaths.toArray(URL[]::new), ext.getClass().getClassLoader()){

                    Class<?> load(String name) throws ClassNotFoundException {
                        return this.findClass(name);
                    }
                };
                try {
                    Constructor<?> ctr = loader.load(ext.processorName()).getDeclaredConstructors()[0];
                    return new ClassLoaderIsolatedJarProcessorProvider(loader, ctr);
                }
                catch (Exception e) {
                    throw Util.rethrow(e);
                }
            });
            processors.put(extName, provider.processor(state));
        }
        return Collections.unmodifiableMap(processors);
    }

    private static String isolatedProcessorProviderKey(Extension<Object> ext, List<Dependency> deps) {
        return ext.getClass().getName() + ":" + ext.processorName() + ":" + deps.hashCode();
    }

    private static void executeTasks(ExecutorService executor, List<Callable<Void>> tasks) {
        try {
            List<Future<Void>> result = executor.invokeAll(tasks, 10L, TimeUnit.MINUTES);
            @Nullable RuntimeException err = null;
            for (Future<Void> f : result) {
                try {
                    f.get();
                }
                catch (CancellationException | ExecutionException e) {
                    if (err == null) {
                        err = new RuntimeException("Exception(s) resolving dependencies");
                    }
                    if (e instanceof ExecutionException) {
                        err.addSuppressed(e.getCause());
                        continue;
                    }
                    err.addSuppressed(e);
                }
            }
            if (err != null) {
                throw err;
            }
        }
        catch (InterruptedException e) {
            throw Util.rethrow(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private FileWithHashes resolve(Dependency dependency, List<String> repositories, DependencyCache cache, Runnable attemptingDownloadCallback) throws IOException {
        Object result;
        Path resolved = null;
        String mavenArtifactPath = String.format("%s/%s/%s/%s-%s%s.%s", dependency.group().replace('.', '/'), dependency.name(), DependencyResolver.nonUniqueSnapshotIfSnapshot(dependency.version()), dependency.name(), dependency.version(), dependency.classifier() == null ? "" : "-" + dependency.classifier(), dependency.extension());
        Path outputFile = cache.cacheDirectory().resolve(mavenArtifactPath);
        if (Files.exists(outputFile, new LinkOption[0])) {
            result = DependencyResolver.withHashes(outputFile);
            if (dependency.sha256().equalsIgnoreCase(((FileWithHashes)result).sha256().asHexString())) {
                DependencyResolver.writeLastUsed(outputFile);
                return result;
            }
            Files.delete(outputFile);
        }
        attemptingDownloadCallback.run();
        for (String string : repositories) {
            HttpResponse<Path> response;
            HttpRequest request;
            void var9_9;
            if (!string.endsWith("/")) {
                String string2 = string + "/";
            }
            String urlString = (String)var9_9 + mavenArtifactPath;
            try {
                request = HttpRequest.newBuilder(new URI(urlString)).GET().header(USER_AGENT_HEADER, USER_AGENT).build();
            }
            catch (URISyntaxException e) {
                throw Util.rethrow(e);
            }
            try {
                this.logger.debug("Attempting download " + urlString);
                response = this.client.send(request, HttpResponse.BodyHandlers.ofFile(Util.mkParentDirs(outputFile), StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE, StandardOpenOption.WRITE));
            }
            catch (InterruptedException e) {
                throw Util.rethrow(e);
            }
            if (response == null || response.statusCode() != 200) {
                this.logger.debug("Failed to download " + urlString + ": " + (String)(response == null ? "null response" : "response code " + response.statusCode()));
                continue;
            }
            this.logger.debug("Successfully downloaded " + urlString);
            resolved = response.body();
            break;
        }
        if (resolved == null) {
            throw new IllegalStateException("Could not resolve %s from any of %s".formatted(dependency, repositories));
        }
        result = DependencyResolver.withHashes(resolved);
        if (!dependency.sha256().equalsIgnoreCase(((FileWithHashes)result).sha256().asHexString())) {
            throw new IllegalStateException("Hash for downloaded file %s was incorrect (expected: %s, got: %s)".formatted(resolved, dependency.sha256(), ((FileWithHashes)result).sha256().asHexString()));
        }
        DependencyResolver.writeLastUsed(resolved);
        return result;
    }

    private static FileWithHashes withHashes(Path file) throws IOException {
        MultiAlgorithmHasher.HashesMap hashes = MULTI_HASHER.hashFile(file);
        return new FileWithHashes(file, hashes.hash(HashingAlgorithm.SHA256), hashes.hash(HashingAlgorithm.SHA1));
    }

    private static String nonUniqueSnapshotIfSnapshot(String version) {
        Matcher matcher = UNIQUE_SNAPSHOT.matcher(version);
        if (matcher.matches()) {
            String timestamp = matcher.group(1);
            return version.replace(timestamp, "SNAPSHOT");
        }
        return version;
    }

    private static void writeLastUsed(Path f) {
        Path file = DependencyResolver.lastUsedFile(f);
        try {
            Files.writeString(file, (CharSequence)String.valueOf(System.currentTimeMillis()), new OpenOption[0]);
        }
        catch (IOException ex) {
            throw Util.rethrow(ex);
        }
    }

    static Path lastUsedFile(Path f) {
        return f.resolveSibling(f.getFileName().toString() + ".last-used.txt");
    }

    static long lastUsed(Path f) {
        Path file = DependencyResolver.lastUsedFile(f);
        if (!Files.isRegularFile(file, new LinkOption[0])) {
            return -1L;
        }
        try {
            return Long.parseLong(Files.readString(file));
        }
        catch (Exception e) {
            throw Util.rethrow(e);
        }
    }

    private ExecutorService makeExecutor() {
        return Executors.newFixedThreadPool(Math.min(4, Runtime.getRuntime().availableProcessors()), new ResolverThreadFactory(this.logger));
    }

    private record ClassLoaderIsolatedJarProcessorProvider(URLClassLoader loader, Constructor<?> processorConstructor) {
        JarProcessor processor(Object config) {
            try {
                return new IsolatedProcessor(this.processorConstructor.newInstance(config));
            }
            catch (Exception e) {
                throw Util.rethrow(e);
            }
        }

        private record IsolatedProcessor(Object processor) implements JarProcessor
        {
            @Override
            public @Nullable String cacheKey() {
                try {
                    Method mth = this.processor.getClass().getDeclaredMethod("cacheKey", new Class[0]);
                    return (String)mth.invoke(this.processor, new Object[0]);
                }
                catch (InvocationTargetException e) {
                    throw Util.rethrow(e.getCause());
                }
                catch (ReflectiveOperationException e) {
                    throw Util.rethrow(e);
                }
            }

            @Override
            public void process(Path input, Path output) {
                try {
                    Method mth = this.processor.getClass().getDeclaredMethod("process", Path.class, Path.class);
                    mth.invoke(this.processor, input, output);
                }
                catch (InvocationTargetException e) {
                    throw Util.rethrow(e.getCause());
                }
                catch (ReflectiveOperationException e) {
                    throw Util.rethrow(e);
                }
            }
        }
    }

    private record FileWithHashes(Path path, HashResult sha256, HashResult sha1) {
    }

    private static final class ResolverThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger poolNumber = new AtomicInteger(1);
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix = DependencyResolver.class.getSimpleName() + "-pool-" + poolNumber.getAndIncrement() + "-thread-";
        private final GremlinLogger logger;

        ResolverThreadFactory(GremlinLogger logger) {
            this.logger = logger;
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thr = new Thread(null, runnable, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            thr.setDaemon(true);
            thr.setPriority(5);
            thr.setUncaughtExceptionHandler((thread, throwable) -> this.logger.warn("Uncaught exception on thread " + thread.getName(), throwable));
            return thr;
        }
    }
}

