/*
 * Decompiled with CFR 0.152.
 */
package carbonchat.libs.xyz.jpenilla.gremlin.runtime;

import carbonchat.libs.xyz.jpenilla.gremlin.runtime.JarProcessor;
import carbonchat.libs.xyz.jpenilla.gremlin.runtime.RelocationExtension;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import me.lucko.jarrelocator.JarRelocator;
import me.lucko.jarrelocator.Relocation;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class RelocationProcessor
implements JarProcessor {
    private final List<Relocation> relocations;
    private final String cacheKey;

    public RelocationProcessor(RelocationExtension.Config config) {
        if (config.relocations().isEmpty()) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " created without any relocations");
        }
        this.relocations = config.relocations().stream().map(line -> {
            String[] split = line.split(" ");
            HashSet<String> includes = new HashSet<String>();
            HashSet<String> excludes = new HashSet<String>();
            if (split.length > 2) {
                block4: for (int i = 2; i < split.length; ++i) {
                    String includeOrExclude = split[i];
                    switch (includeOrExclude.charAt(0)) {
                        case ':': {
                            includes.add(includeOrExclude.substring(1));
                            continue block4;
                        }
                        case '-': {
                            excludes.add(includeOrExclude.substring(1));
                            continue block4;
                        }
                        default: {
                            throw new IllegalStateException("Invalid relocation '" + line + "'");
                        }
                    }
                }
            }
            return new Relocation(split[0], split[1], includes, excludes);
        }).toList();
        this.cacheKey = String.join((CharSequence)";", config.relocations());
    }

    @Override
    public String cacheKey() {
        return this.cacheKey;
    }

    @Override
    public void process(Path input, Path output) throws IOException {
        JarRelocator relocator = new JarRelocator(input.toFile(), output.toFile(), this.relocations);
        relocator.run();
    }
}

