/*
 * Decompiled with CFR 0.152.
 */
package carbonchat.libs.xyz.jpenilla.gremlin.runtime.util;

import carbonchat.libs.xyz.jpenilla.gremlin.runtime.util.HashResult;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import org.jspecify.annotations.NullMarked;

@NullMarked
public record HashingAlgorithm(String algorithmName) {
    public static final HashingAlgorithm SHA1 = new HashingAlgorithm("SHA-1");
    public static final HashingAlgorithm SHA256 = new HashingAlgorithm("SHA-256");

    public HashingAlgorithm {
        Objects.requireNonNull(algorithmName, "algorithmName must not be null");
    }

    public MessageDigest digest() {
        try {
            return MessageDigest.getInstance(this.algorithmName);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException("Could not get MessageDigest instance for '" + this.algorithmName + "' algorithm.", ex);
        }
    }

    public HashResult hashFile(Path file) throws IOException {
        try (InputStream in = Files.newInputStream(file, new OpenOption[0]);){
            HashResult hashResult = this.hash(in);
            return hashResult;
        }
    }

    public HashResult hashString(String s) {
        byte[] hash = this.digest().digest(s.getBytes(StandardCharsets.UTF_8));
        return new HashResult(hash);
    }

    public HashResult hash(InputStream stream) throws IOException {
        return HashingAlgorithm.calculateHash(stream, this.digest());
    }

    private static HashResult calculateHash(InputStream stream, MessageDigest digest) throws IOException {
        int count;
        byte[] buffer = new byte[8192];
        while ((count = stream.read(buffer)) != -1) {
            digest.update(buffer, 0, count);
        }
        return new HashResult(digest.digest());
    }
}

