/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.api.channels;

import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import java.util.function.Supplier;
import net.draycia.carbon.api.channels.ChannelPermissionResultImpl;
import net.kyori.adventure.text.Component;

@DefaultQualifier(value=NonNull.class)
public interface ChannelPermissionResult {
    public boolean permitted();

    public Component reason();

    public static ChannelPermissionResult allowed() {
        return ChannelPermissionResultImpl.ALLOWED;
    }

    public static ChannelPermissionResult denied(Component reason) {
        return new ChannelPermissionResultImpl(false, () -> reason);
    }

    public static ChannelPermissionResult denied(Supplier<Component> reason) {
        return new ChannelPermissionResultImpl(false, reason);
    }

    public static ChannelPermissionResult channelPermissionResult(boolean allowed, Supplier<Component> denyReason) {
        if (allowed) {
            return ChannelPermissionResult.allowed();
        }
        return ChannelPermissionResult.denied(denyReason);
    }
}

