/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common;

import carbonchat.libs.com.google.inject.Injector;
import carbonchat.libs.com.google.inject.Key;
import carbonchat.libs.com.google.inject.Provider;
import carbonchat.libs.com.google.inject.TypeLiteral;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.draycia.carbon.api.CarbonChat;
import net.draycia.carbon.api.CarbonServer;
import net.draycia.carbon.api.event.CarbonEventHandler;
import net.draycia.carbon.api.users.UserManager;
import net.draycia.carbon.common.channels.CarbonChannelRegistry;
import net.draycia.carbon.common.command.CarbonCommand;
import net.draycia.carbon.common.command.ExecutionCoordinatorHolder;
import net.draycia.carbon.common.config.ConfigManager;
import net.draycia.carbon.common.integration.Integration;
import net.draycia.carbon.common.listeners.Listener;
import net.draycia.carbon.common.messages.CarbonMessages;
import net.draycia.carbon.common.messaging.MessagingManager;
import net.draycia.carbon.common.messaging.packets.PacketFactory;
import net.draycia.carbon.common.users.PlayerUtils;
import net.draycia.carbon.common.users.ProfileCache;
import net.draycia.carbon.common.users.ProfileResolver;
import net.draycia.carbon.common.users.UserManagerInternal;
import net.draycia.carbon.common.util.CloudUtils;
import net.draycia.carbon.common.util.ConcurrentUtil;
import net.draycia.carbon.common.util.UpdateChecker;
import org.apache.logging.log4j.Logger;

@DefaultQualifier(value=NonNull.class)
public abstract class CarbonChatInternal
implements CarbonChat {
    private final Injector injector;
    private final Logger logger;
    private final ScheduledExecutorService periodicTasks;
    private final ProfileCache profileCache;
    private final ProfileResolver profileResolver;
    private final UserManagerInternal<?> userManager;
    private final ExecutionCoordinatorHolder commandExecutor;
    private final CarbonServer carbonServer;
    private final CarbonMessages carbonMessages;
    private final CarbonEventHandler eventHandler;
    private final CarbonChannelRegistry channelRegistry;
    private final Provider<MessagingManager> messagingManager;

    protected CarbonChatInternal(Injector injector, Logger logger, ScheduledExecutorService periodicTasks, ProfileCache profileCache, ProfileResolver profileResolver, UserManagerInternal<?> userManager, ExecutionCoordinatorHolder commandExecutor, CarbonServer carbonServer, CarbonMessages carbonMessages, CarbonEventHandler eventHandler, CarbonChannelRegistry channelRegistry, Provider<MessagingManager> messagingManagerProvider) {
        this.injector = injector;
        this.logger = logger;
        this.periodicTasks = periodicTasks;
        this.profileCache = profileCache;
        this.profileResolver = profileResolver;
        this.userManager = userManager;
        this.commandExecutor = commandExecutor;
        this.carbonServer = carbonServer;
        this.carbonMessages = carbonMessages;
        this.eventHandler = eventHandler;
        this.channelRegistry = channelRegistry;
        this.messagingManager = messagingManagerProvider;
    }

    protected void init() {
        Set listeners = (Set)this.injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<Listener>>(this){}));
        Set commands = (Set)this.injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<CarbonCommand>>(this){}));
        CloudUtils.registerCommands(commands, ((ConfigManager)this.injector.getInstance(ConfigManager.class)).loadCommandSettings());
        this.periodicTasks.scheduleAtFixedRate(() -> PlayerUtils.saveLoggedInPlayers(this.carbonServer, this.userManager, this.logger), 5L, 5L, TimeUnit.MINUTES);
        this.periodicTasks.scheduleAtFixedRate(this.profileCache::save, 15L, 15L, TimeUnit.MINUTES);
        this.periodicTasks.scheduleAtFixedRate(this.userManager::cleanup, 30L, 30L, TimeUnit.SECONDS);
        Set integrations = (Set)this.injector().getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<Integration>>(this){}));
        for (Integration integration : integrations) {
            if (!integration.eligible()) continue;
            integration.register();
        }
        this.channelRegistry().loadConfigChannels(this.carbonMessages);
        this.messagingManager.get();
    }

    protected final void checkVersion() {
        if (!((ConfigManager)this.injector.getInstance(ConfigManager.class)).primaryConfig().updateChecker()) {
            return;
        }
        CompletableFuture.runAsync(() -> new UpdateChecker(this.logger).checkVersion()).whenComplete(($, thr) -> {
            if (thr != null) {
                this.logger.warn("Exception fetching version information", thr);
            }
        });
    }

    protected void shutdown() {
        ((MessagingManager)this.messagingManager.get()).queuePacket(() -> ((PacketFactory)this.injector.getInstance(PacketFactory.class)).clearLocalPlayersPacket());
        ((MessagingManager)this.messagingManager.get()).onShutdown();
        ConcurrentUtil.shutdownExecutor(this.periodicTasks, TimeUnit.MILLISECONDS, 500L);
        this.profileCache.save();
        this.profileResolver.shutdown();
        this.userManager.shutdown();
        this.commandExecutor.shutdown();
    }

    public Logger logger() {
        return this.logger;
    }

    @Override
    public CarbonServer server() {
        return this.carbonServer;
    }

    @Override
    public UserManager<?> userManager() {
        return this.userManager;
    }

    @Override
    public CarbonEventHandler eventHandler() {
        return this.eventHandler;
    }

    @Override
    public CarbonChannelRegistry channelRegistry() {
        return this.channelRegistry;
    }

    public boolean isProxy() {
        return false;
    }

    public Injector injector() {
        return this.injector;
    }
}

