/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common;

import carbonchat.libs.com.google.inject.AbstractModule;
import carbonchat.libs.com.google.inject.Binder;
import carbonchat.libs.com.google.inject.Injector;
import carbonchat.libs.com.google.inject.Key;
import carbonchat.libs.com.google.inject.Module;
import carbonchat.libs.com.google.inject.Provides;
import carbonchat.libs.com.google.inject.Scopes;
import carbonchat.libs.com.google.inject.Singleton;
import carbonchat.libs.com.google.inject.TypeLiteral;
import carbonchat.libs.com.google.inject.assistedinject.FactoryModuleBuilder;
import carbonchat.libs.com.google.inject.assistedinject.FactoryProvider3;
import carbonchat.libs.com.google.inject.multibindings.Multibinder;
import carbonchat.libs.net.kyori.moonshine.Moonshine;
import carbonchat.libs.net.kyori.moonshine.exception.scan.UnscannableMethodException;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import carbonchat.libs.org.jdbi.v3.core.Jdbi;
import carbonchat.libs.org.jdbi.v3.core.argument.ArgumentFactory;
import carbonchat.libs.org.jdbi.v3.core.h2.H2DatabasePlugin;
import carbonchat.libs.org.jdbi.v3.core.mapper.ColumnMapper;
import carbonchat.libs.org.jdbi.v3.core.spi.JdbiPlugin;
import carbonchat.libs.org.jdbi.v3.postgres.PostgresPlugin;
import carbonchat.libs.org.spongepowered.configurate.util.NamingSchemes;
import io.leangen.geantyref.TypeToken;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import net.draycia.carbon.api.channels.ChannelRegistry;
import net.draycia.carbon.api.event.CarbonEventHandler;
import net.draycia.carbon.api.users.UserManager;
import net.draycia.carbon.common.DataDirectory;
import net.draycia.carbon.common.PeriodicTasks;
import net.draycia.carbon.common.channels.CarbonChannelRegistry;
import net.draycia.carbon.common.command.CarbonCommand;
import net.draycia.carbon.common.command.ExecutionCoordinatorHolder;
import net.draycia.carbon.common.command.ParserFactory;
import net.draycia.carbon.common.command.argument.PlayerSuggestions;
import net.draycia.carbon.common.command.commands.ClearChatCommand;
import net.draycia.carbon.common.command.commands.ContinueCommand;
import net.draycia.carbon.common.command.commands.DebugCommand;
import net.draycia.carbon.common.command.commands.FilterCommand;
import net.draycia.carbon.common.command.commands.HelpCommand;
import net.draycia.carbon.common.command.commands.IgnoreCommand;
import net.draycia.carbon.common.command.commands.IgnoreListCommand;
import net.draycia.carbon.common.command.commands.JoinCommand;
import net.draycia.carbon.common.command.commands.LeaveCommand;
import net.draycia.carbon.common.command.commands.MuteCommand;
import net.draycia.carbon.common.command.commands.MuteInfoCommand;
import net.draycia.carbon.common.command.commands.NicknameCommand;
import net.draycia.carbon.common.command.commands.PartyCommands;
import net.draycia.carbon.common.command.commands.ReloadCommand;
import net.draycia.carbon.common.command.commands.ReplyCommand;
import net.draycia.carbon.common.command.commands.SpyCommand;
import net.draycia.carbon.common.command.commands.ToggleMessagesCommand;
import net.draycia.carbon.common.command.commands.UnignoreCommand;
import net.draycia.carbon.common.command.commands.UnmuteCommand;
import net.draycia.carbon.common.command.commands.UpdateUsernameCommand;
import net.draycia.carbon.common.command.commands.WhisperCommand;
import net.draycia.carbon.common.config.ConfigManager;
import net.draycia.carbon.common.config.DatabaseSettings;
import net.draycia.carbon.common.config.PrimaryConfig;
import net.draycia.carbon.common.event.CarbonEventHandlerImpl;
import net.draycia.carbon.common.listeners.DeafenHandler;
import net.draycia.carbon.common.listeners.FilterHandler;
import net.draycia.carbon.common.listeners.HyperlinkHandler;
import net.draycia.carbon.common.listeners.IgnoreHandler;
import net.draycia.carbon.common.listeners.ItemLinkHandler;
import net.draycia.carbon.common.listeners.Listener;
import net.draycia.carbon.common.listeners.MessagePacketHandler;
import net.draycia.carbon.common.listeners.MuteHandler;
import net.draycia.carbon.common.listeners.PartyChatSpyHandler;
import net.draycia.carbon.common.listeners.PartyPingHandler;
import net.draycia.carbon.common.listeners.PingHandler;
import net.draycia.carbon.common.listeners.RadiusListener;
import net.draycia.carbon.common.messages.CarbonMessageRenderer;
import net.draycia.carbon.common.messages.CarbonMessageSender;
import net.draycia.carbon.common.messages.CarbonMessageSource;
import net.draycia.carbon.common.messages.CarbonMessages;
import net.draycia.carbon.common.messages.Option;
import net.draycia.carbon.common.messages.RenderForTagResolver;
import net.draycia.carbon.common.messages.SourcedReceiverResolver;
import net.draycia.carbon.common.messages.StandardPlaceholderResolverStrategyButDifferent;
import net.draycia.carbon.common.messages.placeholders.BooleanPlaceholderResolver;
import net.draycia.carbon.common.messages.placeholders.ComponentPlaceholderResolver;
import net.draycia.carbon.common.messages.placeholders.IntPlaceholderResolver;
import net.draycia.carbon.common.messages.placeholders.KeyPlaceholderResolver;
import net.draycia.carbon.common.messages.placeholders.LongPlaceholderResolver;
import net.draycia.carbon.common.messages.placeholders.OptionPlaceholderResolver;
import net.draycia.carbon.common.messages.placeholders.StringPlaceholderResolver;
import net.draycia.carbon.common.messages.placeholders.UUIDPlaceholderResolver;
import net.draycia.carbon.common.messaging.ServerId;
import net.draycia.carbon.common.messaging.packets.PacketFactory;
import net.draycia.carbon.common.users.Backing;
import net.draycia.carbon.common.users.CarbonPlayerCommon;
import net.draycia.carbon.common.users.NetworkUsers;
import net.draycia.carbon.common.users.PlatformUserManager;
import net.draycia.carbon.common.users.UserManagerInternal;
import net.draycia.carbon.common.users.db.DatabaseUserManager;
import net.draycia.carbon.common.users.db.argument.BinaryUUIDArgumentFactory;
import net.draycia.carbon.common.users.db.mapper.BinaryUUIDColumnMapper;
import net.draycia.carbon.common.users.db.mapper.NativeUUIDColumnMapper;
import net.draycia.carbon.common.users.json.JSONUserManager;
import net.draycia.carbon.common.util.CloudUtils;
import net.draycia.carbon.common.util.ConcurrentUtil;
import net.draycia.carbon.common.util.Exceptions;
import net.draycia.carbon.common.util.FileUtil;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import org.apache.logging.log4j.Logger;

@DefaultQualifier(value=NonNull.class)
public final class CarbonCommonModule
extends AbstractModule {
    @Provides
    @Backing
    @Singleton
    public UserManagerInternal<CarbonPlayerCommon> userManager(@DataDirectory Path dataDirectory, ConfigManager configManager, Logger logger, Injector injector) throws IOException {
        PrimaryConfig.StorageType storageType = configManager.primaryConfig().storageType();
        String smokeTestMode = System.getProperty("carbonchat.smokeTestMode");
        if (smokeTestMode != null) {
            logger.info("Smoke test: Overriding storage manager.");
            switch (smokeTestMode) {
                case "h2": {
                    storageType = PrimaryConfig.StorageType.H2;
                    break;
                }
                case "json": {
                    storageType = PrimaryConfig.StorageType.JSON;
                    break;
                }
                case "postgres": {
                    storageType = PrimaryConfig.StorageType.PSQL;
                    configManager.primaryConfig().databaseSettings().url("jdbc:postgresql://localhost:5432/carbon");
                    break;
                }
                case "mariadb": {
                    storageType = PrimaryConfig.StorageType.MYSQL;
                    configManager.primaryConfig().databaseSettings().url("jdbc:mariadb://localhost:3306/carbon");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown smoke test mode: " + smokeTestMode);
                }
            }
        }
        logger.info("Initializing {} storage manager...", (Object)storageType);
        return switch (storageType) {
            default -> throw new MatchException(null, null);
            case PrimaryConfig.StorageType.MYSQL -> ((DatabaseUserManager.Factory)injector.getInstance(DatabaseUserManager.Factory.class)).create("queries/migrations/mysql", jdbi -> ((Jdbi)jdbi.registerArgument((ArgumentFactory)new BinaryUUIDArgumentFactory())).registerColumnMapper(UUID.class, (ColumnMapper)new BinaryUUIDColumnMapper()));
            case PrimaryConfig.StorageType.PSQL -> ((DatabaseUserManager.Factory)injector.getInstance(DatabaseUserManager.Factory.class)).create("queries/migrations/postgresql", jdbi -> ((Jdbi)jdbi.registerColumnMapper(UUID.class, (ColumnMapper)new NativeUUIDColumnMapper())).installPlugin((JdbiPlugin)new PostgresPlugin()));
            case PrimaryConfig.StorageType.H2 -> ((DatabaseUserManager.Factory)injector.getInstance(DatabaseUserManager.Factory.class)).create("queries/migrations/h2", jdbi -> jdbi.installPlugin((JdbiPlugin)new H2DatabasePlugin()), new DatabaseSettings("jdbc:h2:" + String.valueOf(FileUtil.mkParentDirs(dataDirectory.resolve("users/userdata-h2")).toAbsolutePath()) + ";MODE=MySQL", "", ""));
            case PrimaryConfig.StorageType.JSON -> (JSONUserManager)injector.getInstance(JSONUserManager.class);
        };
    }

    @Provides
    @PeriodicTasks
    @Singleton
    public ScheduledExecutorService periodicTasksExecutor(Logger logger) {
        return ConcurrentUtil.createPeriodicTasksPool(logger);
    }

    @Provides
    @Singleton
    public CarbonMessages carbonMessages(SourcedReceiverResolver receiverResolver, ComponentPlaceholderResolver<Audience> componentPlaceholderResolver, UUIDPlaceholderResolver<Audience> uuidPlaceholderResolver, StringPlaceholderResolver<Audience> stringPlaceholderResolver, IntPlaceholderResolver<Audience> intPlaceholderResolver, LongPlaceholderResolver<Audience> longPlaceholderResolver, KeyPlaceholderResolver<Audience> keyPlaceholderResolver, BooleanPlaceholderResolver<Audience> booleanPlaceholderResolver, CarbonMessageSource carbonMessageSource, CarbonMessageSender carbonMessageSender, CarbonMessageRenderer messageRenderer) throws UnscannableMethodException {
        return Moonshine.builder(new TypeToken<CarbonMessages>(this){}).receiverLocatorResolver(receiverResolver, 0).sourced(carbonMessageSource).rendered(messageRenderer).sent(carbonMessageSender).resolvingWithStrategy(new StandardPlaceholderResolverStrategyButDifferent(NamingSchemes.SNAKE_CASE)).weightedPlaceholderResolver(Component.class, componentPlaceholderResolver, 0).weightedPlaceholderResolver(UUID.class, uuidPlaceholderResolver, 0).weightedPlaceholderResolver(String.class, stringPlaceholderResolver, 0).weightedPlaceholderResolver(Integer.class, intPlaceholderResolver, 0).weightedPlaceholderResolver(Long.class, longPlaceholderResolver, 0).weightedPlaceholderResolver(net.kyori.adventure.key.Key.class, keyPlaceholderResolver, 0).weightedPlaceholderResolver(Boolean.class, booleanPlaceholderResolver, 0).weightedPlaceholderResolver(Option.class, new OptionPlaceholderResolver(), 0).create(((Object)((Object)this)).getClass().getClassLoader());
    }

    @Provides
    @Singleton
    public ExecutionCoordinatorHolder executionCoordinatorHolder(Logger logger) {
        return ExecutionCoordinatorHolder.create(logger);
    }

    protected void configure() {
        this.install(new FactoryModuleBuilder().build(ParserFactory.class));
        this.install(new FactoryModuleBuilder().build(RenderForTagResolver.Factory.class));
        this.install(CarbonCommonModule.factoryModule(PacketFactory.class));
        this.bind(ServerId.KEY).toInstance((Object)UUID.randomUUID());
        this.bind(ChannelRegistry.class).to(CarbonChannelRegistry.class);
        this.bind(CarbonEventHandler.class).to(CarbonEventHandlerImpl.class);
        this.bind(PlayerSuggestions.class).to(NetworkUsers.class);
        this.bind(new TypeLiteral<UserManager<?>>(this){}).to(PlatformUserManager.class);
        this.bind(new TypeLiteral<UserManagerInternal<?>>(this){}).to(PlatformUserManager.class);
        this.configureListeners();
        this.configureCommands();
    }

    private void configureListeners() {
        Multibinder listeners = Multibinder.newSetBinder((Binder)this.binder(), Listener.class);
        listeners.addBinding().to(DeafenHandler.class);
        listeners.addBinding().to(FilterHandler.class);
        listeners.addBinding().to(HyperlinkHandler.class);
        listeners.addBinding().to(IgnoreHandler.class);
        listeners.addBinding().to(ItemLinkHandler.class);
        listeners.addBinding().to(MessagePacketHandler.class);
        listeners.addBinding().to(MuteHandler.class);
        listeners.addBinding().to(PartyChatSpyHandler.class);
        listeners.addBinding().to(PartyPingHandler.class);
        listeners.addBinding().to(PingHandler.class);
        listeners.addBinding().to(RadiusListener.class);
    }

    private void configureCommands() {
        this.requestStaticInjection(new Class[]{CloudUtils.class});
        Multibinder commands = Multibinder.newSetBinder((Binder)this.binder(), CarbonCommand.class);
        commands.addBinding().to(ClearChatCommand.class).in(Scopes.SINGLETON);
        commands.addBinding().to(ContinueCommand.class).in(Scopes.SINGLETON);
        commands.addBinding().to(DebugCommand.class).in(Scopes.SINGLETON);
        commands.addBinding().to(FilterCommand.class).in(Scopes.SINGLETON);
        commands.addBinding().to(HelpCommand.class).in(Scopes.SINGLETON);
        commands.addBinding().to(IgnoreCommand.class).in(Scopes.SINGLETON);
        commands.addBinding().to(MuteCommand.class).in(Scopes.SINGLETON);
        commands.addBinding().to(MuteInfoCommand.class).in(Scopes.SINGLETON);
        commands.addBinding().to(NicknameCommand.class).in(Scopes.SINGLETON);
        commands.addBinding().to(ReloadCommand.class).in(Scopes.SINGLETON);
        commands.addBinding().to(ReplyCommand.class).in(Scopes.SINGLETON);
        commands.addBinding().to(SpyCommand.class).in(Scopes.SINGLETON);
        commands.addBinding().to(ToggleMessagesCommand.class).in(Scopes.SINGLETON);
        commands.addBinding().to(UnignoreCommand.class).in(Scopes.SINGLETON);
        commands.addBinding().to(UnmuteCommand.class).in(Scopes.SINGLETON);
        commands.addBinding().to(UpdateUsernameCommand.class).in(Scopes.SINGLETON);
        commands.addBinding().to(WhisperCommand.class).in(Scopes.SINGLETON);
        commands.addBinding().to(JoinCommand.class).in(Scopes.SINGLETON);
        commands.addBinding().to(LeaveCommand.class).in(Scopes.SINGLETON);
        commands.addBinding().to(IgnoreListCommand.class).in(Scopes.SINGLETON);
        commands.addBinding().to(PartyCommands.class).in(Scopes.SINGLETON);
    }

    private static <T> Module factoryModule(final Class<T> factoryInterface) {
        return new AbstractModule(){

            protected void configure() {
                try {
                    FactoryProvider3 factoryProvider = new FactoryProvider3(Key.get((TypeLiteral)TypeLiteral.get((Class)factoryInterface)), null, MethodHandles.privateLookupIn(factoryInterface, MethodHandles.lookup()));
                    this.binder().bind(factoryInterface).toProvider(factoryProvider);
                }
                catch (Exception e) {
                    throw Exceptions.rethrow(e);
                }
            }
        };
    }
}

