/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.channels;

import carbonchat.libs.com.google.inject.Inject;
import carbonchat.libs.com.google.inject.Injector;
import carbonchat.libs.com.google.inject.Singleton;
import carbonchat.libs.com.google.inject.TypeLiteral;
import carbonchat.libs.com.seiama.registry.Holder;
import carbonchat.libs.com.seiama.registry.Registry;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.Nullable;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import carbonchat.libs.org.spongepowered.configurate.ConfigurateException;
import carbonchat.libs.org.spongepowered.configurate.ConfigurationNode;
import carbonchat.libs.org.spongepowered.configurate.loader.ConfigurationLoader;
import carbonchat.libs.org.spongepowered.configurate.transformation.ConfigurationTransformation;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.draycia.carbon.api.channels.ChannelPermissions;
import net.draycia.carbon.api.channels.ChannelRegistry;
import net.draycia.carbon.api.channels.ChatChannel;
import net.draycia.carbon.api.event.CarbonEventHandler;
import net.draycia.carbon.api.event.events.CarbonChannelRegisterEvent;
import net.draycia.carbon.api.users.CarbonPlayer;
import net.draycia.carbon.common.DataDirectory;
import net.draycia.carbon.common.RawChat;
import net.draycia.carbon.common.channels.ChannelPermissionsImpl;
import net.draycia.carbon.common.channels.ConfigChatChannel;
import net.draycia.carbon.common.channels.PartyChatChannel;
import net.draycia.carbon.common.command.Commander;
import net.draycia.carbon.common.command.PlayerCommander;
import net.draycia.carbon.common.config.ConfigManager;
import net.draycia.carbon.common.event.events.CarbonChatEventImpl;
import net.draycia.carbon.common.event.events.CarbonReloadEvent;
import net.draycia.carbon.common.event.events.ChannelRegisterEventImpl;
import net.draycia.carbon.common.event.events.ChannelSwitchEventImpl;
import net.draycia.carbon.common.listeners.ChatListenerInternal;
import net.draycia.carbon.common.messages.CarbonMessages;
import net.draycia.carbon.common.users.ConsoleCarbonPlayer;
import net.draycia.carbon.common.util.Exceptions;
import net.draycia.carbon.common.util.FileUtil;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.chat.ChatType;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.Keyed;
import org.apache.logging.log4j.Logger;
import org.incendo.cloud.Command;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.minecraft.signed.SignedGreedyStringParser;
import org.incendo.cloud.minecraft.signed.SignedString;
import org.incendo.cloud.parser.ParserDescriptor;
import org.incendo.cloud.permission.PredicatePermission;

@Singleton
@DefaultQualifier(value=NonNull.class)
public class CarbonChannelRegistry
extends ChatListenerInternal
implements ChannelRegistry {
    private final Path configChannelDir;
    private final Injector injector;
    private final Logger logger;
    private final ConfigManager config;
    private @MonotonicNonNull Key defaultKey;
    private final CarbonMessages carbonMessages;
    private final CarbonEventHandler eventHandler;
    private final Key rawChatKey;
    private final Map<String, SpecialHandler<?>> handlers = new HashMap();
    private volatile Registry<Key, ChatChannel> channelRegistry = Registry.create();
    private final Set<Key> configChannels = ConcurrentHashMap.newKeySet();

    public <T extends ConfigChatChannel> void registerSpecialConfigChannel(String fileName, Class<T> type) {
        if (this.handlers.containsKey(fileName)) {
            throw new IllegalStateException("Attempting to register duplicate entry (existing: " + String.valueOf(this.handlers.get(fileName)) + ", new: " + String.valueOf(type) + ") for key " + fileName);
        }
        this.handlers.put(fileName, new SpecialHandler<ConfigChatChannel>(type, () -> (ConfigChatChannel)this.injector.getInstance(type)));
    }

    @Inject
    public CarbonChannelRegistry(@DataDirectory Path dataDirectory, Injector injector, Logger logger, ConfigManager config, CarbonMessages carbonMessages, CarbonEventHandler events, @RawChat Key rawChatKey) {
        super(events, carbonMessages, config);
        this.configChannelDir = dataDirectory.resolve("channels");
        this.injector = injector;
        this.logger = logger;
        this.config = config;
        this.carbonMessages = carbonMessages;
        this.eventHandler = events;
        this.rawChatKey = rawChatKey;
        if (config.primaryConfig().partyChat().enabled) {
            this.registerSpecialConfigChannel("partychat.conf", PartyChatChannel.class);
        }
        events.subscribe(CarbonReloadEvent.class, -99, true, event -> this.reloadConfigChannels());
    }

    public static ConfigurationTransformation.Versioned configChatChannelUpgrader() {
        return ConfigurationTransformation.versionedBuilder().versionKey("config-version").build();
    }

    public static <N extends ConfigurationNode> N upgradeConfigChatChannelNode(N node) throws ConfigurateException {
        return node;
    }

    public void reloadConfigChannels() {
        Registry<Key, ChatChannel> newRegistry = Registry.create();
        for (Key registered : this.channelRegistry.keys()) {
            if (this.configChannels.contains(registered)) continue;
            newRegistry.register(registered, this.channelRegistry.getHolder(registered).valueOrThrow());
        }
        Set<Key> oldConfigChannels = Set.copyOf(this.configChannels);
        this.configChannels.clear();
        Registry<Key, ChatChannel> oldRegistry = this.channelRegistry;
        this.channelRegistry = newRegistry;
        this.loadConfigChannels_(this.carbonMessages);
        for (Key old : oldConfigChannels) {
            if (this.configChannels.contains(old)) continue;
            this.configChannels.add(old);
            this.channelRegistry.register(old, oldRegistry.getHolder(old).valueOrThrow());
            this.logger.warn("The config file for channel [{}] was deleted, but removing channels at runtime is not currently supported. You must restart the plugin for the removal to take effect.", (Object)old);
        }
        HashSet<Key> newConfigChannels = new HashSet<Key>();
        for (Key configChannel : this.configChannels) {
            if (oldConfigChannels.contains(configChannel)) continue;
            newConfigChannels.add(configChannel);
        }
        if (!newConfigChannels.isEmpty()) {
            this.eventHandler.emit(new ChannelRegisterEventImpl(this, Set.copyOf(newConfigChannels)));
        }
    }

    public void loadConfigChannels(CarbonMessages messages) {
        this.loadConfigChannels_(messages);
        this.eventHandler.emit(new ChannelRegisterEventImpl(this, Set.copyOf(this.configChannels)));
    }

    private void loadConfigChannels_(CarbonMessages messages) {
        this.logger.info("Loading config channels...");
        this.defaultKey = this.config.primaryConfig().defaultChannel();
        this.saveSpecialDefaults();
        List<Path> channelConfigs = FileUtil.listDirectoryEntries(this.configChannelDir, "*.conf");
        Set channelConfigFileNames = channelConfigs.stream().map(Path::getFileName).map(Path::toString).collect(Collectors.toSet());
        Set<String> expectedHandlerFileNames = this.handlers.keySet();
        if (channelConfigs.size() == this.handlers.size() && channelConfigFileNames.containsAll(expectedHandlerFileNames)) {
            this.saveDefaultChannelConfig();
            channelConfigs = FileUtil.listDirectoryEntries(this.configChannelDir, "*.conf");
        }
        for (Path path : channelConfigs) {
            ChatChannel chatChannel;
            String fileName = path.getFileName().toString();
            if (!fileName.endsWith(".conf") || (chatChannel = this.loadChannel(path)) == null) continue;
            Key channelKey = chatChannel.key();
            if (this.defaultKey.equals((Object)channelKey)) {
                this.logger.info("Default channel is [{}]", (Object)channelKey);
            }
            if (this.channelRegistry.keys().contains(channelKey)) {
                this.logger.warn("Channel with key [{}] has already been registered, skipping {}", (Object)channelKey, (Object)path);
                continue;
            }
            this.injector.injectMembers((Object)chatChannel);
            this.configChannels.add(chatChannel.key());
            this.register(chatChannel, false);
        }
        if (this.channel(this.defaultKey) == null) {
            this.logger.warn("No default channel found! Default channel key: [{}]", (Object)this.defaultKey());
        }
        ArrayList<String> channelList = new ArrayList<String>();
        for (Key key : this.keys()) {
            channelList.add(key.asString());
        }
        String string = String.join((CharSequence)", ", channelList);
        this.logger.info("Registered channels: [{}]", (Object)string);
    }

    private void saveSpecialDefaults() {
        for (Map.Entry<String, SpecialHandler<?>> e : this.handlers.entrySet()) {
            Path configFile = this.configChannelDir.resolve(e.getKey());
            if (Files.isRegularFile(configFile, new LinkOption[0])) continue;
            try {
                ConfigChatChannel configChannel = (ConfigChatChannel)e.getValue().defaultSupplier().get();
                ConfigurationLoader<?> loader = this.config.configurationLoader(FileUtil.mkParentDirs(configFile), ConfigManager.extractHeader(e.getValue().cls()));
                Object node = loader.createNode();
                node.set(e.getValue().cls(), (Object)configChannel);
                loader.save((ConfigurationNode)node);
            }
            catch (IOException exception) {
                throw Exceptions.rethrow(exception);
            }
        }
    }

    private void saveDefaultChannelConfig() {
        try {
            Path configFile = this.configChannelDir.resolve("global.conf");
            ConfigChatChannel configChannel = (ConfigChatChannel)this.injector.getInstance(ConfigChatChannel.class);
            ConfigurationLoader<?> loader = this.config.configurationLoader(FileUtil.mkParentDirs(configFile), ConfigManager.extractHeader(ConfigChatChannel.class));
            Object node = loader.createNode();
            node.set(ConfigChatChannel.class, (ConfigChatChannel)configChannel);
            loader.save((ConfigurationNode)node);
        }
        catch (IOException exception) {
            throw Exceptions.rethrow(exception);
        }
    }

    private @Nullable ChatChannel loadChannel(Path channelFile) {
        try {
            @Nullable SpecialHandler<?> special = this.handlers.get(channelFile.getFileName().toString());
            Class type = special == null ? ConfigChatChannel.class : special.cls();
            ConfigurationLoader<?> loader = this.config.configurationLoader(channelFile, ConfigManager.extractHeader(type));
            Object loaded = CarbonChannelRegistry.upgradeConfigChatChannelNode(loader.load());
            @Nullable ConfigChatChannel channel = loaded.get(type);
            if (channel == null) {
                throw new ConfigurateException("Config deserialized to null.");
            }
            loaded.set((Type)((Object)type), (Object)channel);
            loader.save((ConfigurationNode)loaded);
            return channel;
        }
        catch (ConfigurateException exception) {
            this.logger.warn("Failed to load channel from file '{}'", (Object)channelFile, (Object)exception);
            return null;
        }
    }

    private void sendMessageInChannelAsConsole(Audience sender, ChatChannel channel, String plainMessage) {
        this.sendMessageInChannel(new ConsoleCarbonPlayer(sender), channel, SignedString.unsigned((String)plainMessage));
    }

    private void sendMessageInChannel(CarbonPlayer sender, ChatChannel channel, SignedString message) {
        @Nullable CarbonChatEventImpl chatEvent = this.prepareAndEmitChatEvent(sender, message.string(), message.signedMessage(), channel);
        if (chatEvent == null || chatEvent.cancelled()) {
            return;
        }
        for (Audience audience : chatEvent.recipients()) {
            message.sendMessage(audience, ChatType.chatType((Keyed)this.rawChatKey), chatEvent.renderFor(audience));
        }
    }

    private void registerChannelCommands(ChatChannel channel) {
        CommandManager commandManager = (CommandManager)this.injector.getInstance(carbonchat.libs.com.google.inject.Key.get((TypeLiteral)new TypeLiteral<CommandManager<Commander>>(this){}));
        if (!commandManager.isCommandRegistrationAllowed() || commandManager.commandTree().getNamedNode(channel.commandName()) != null) {
            return;
        }
        Command.Builder builder = commandManager.commandBuilder(channel.commandName(), channel.commandAliases(), commandManager.createDefaultCommandMeta()).optional("message", (ParserDescriptor)SignedGreedyStringParser.signedGreedyStringParser());
        if (!channel.permissions().dynamic()) {
            builder = builder.permission(PredicatePermission.of(sender -> {
                if (!(sender instanceof PlayerCommander)) {
                    return true;
                }
                PlayerCommander player = (PlayerCommander)sender;
                return channel.permissions().joinPermitted(player.carbonPlayer()).permitted();
            }));
        }
        Key channelKey = channel.key();
        Command command = builder.senderType(Commander.class).handler(handler -> {
            Commander commander = (Commander)handler.sender();
            @Nullable ChatChannel chatChannel = this.channel(channelKey);
            if (!(commander instanceof PlayerCommander)) {
                if (chatChannel != null && handler.contains("message")) {
                    SignedString message = (SignedString)handler.get("message");
                    this.sendMessageInChannelAsConsole(commander, chatChannel, message.string());
                }
                return;
            }
            PlayerCommander playerCommander = (PlayerCommander)commander;
            CarbonPlayer player = playerCommander.carbonPlayer();
            if (player.muted()) {
                this.carbonMessages.muteCannotSpeak(player);
                return;
            }
            if (player.leftChannels().contains(channelKey) && chatChannel != null) {
                player.joinChannel(chatChannel);
                this.carbonMessages.channelJoined(player);
            }
            if (handler.contains("message")) {
                SignedString message = (SignedString)handler.get("message");
                this.sendMessageInChannel(player, chatChannel, message);
            } else {
                @Nullable ChatChannel fromChannel = player.selectedChannel();
                if (this.config.primaryConfig().returnToDefaultChannel() && fromChannel != null && fromChannel.key().equals((Object)channelKey)) {
                    chatChannel = this.defaultChannel();
                }
                ChannelSwitchEventImpl switchEvent = new ChannelSwitchEventImpl(player, chatChannel);
                this.eventHandler.emit(switchEvent);
                player.selectedChannel(switchEvent.channel());
                this.carbonMessages.changedChannels(player, chatChannel.key().value());
            }
        }).build();
        commandManager.command(command);
        Command channelCommand = commandManager.commandBuilder("channel", new String[]{"ch"}).literal(channelKey.value(), new String[0]).proxies(command).build();
        commandManager.command(channelCommand);
    }

    @Override
    public void register(ChatChannel channel) {
        this.register(channel, true);
    }

    public void register(ChatChannel channel, boolean fireRegisterEvent) {
        this.channelRegistry.register(channel.key(), channel);
        if (channel.shouldRegisterCommands()) {
            this.registerChannelCommands(channel);
        }
        if (fireRegisterEvent) {
            this.eventHandler.emit(new ChannelRegisterEventImpl(this, Set.of(channel.key())));
        }
    }

    @Override
    public @Nullable ChatChannel channel(Key key) {
        @Nullable Holder<Key, ChatChannel> holder = this.channelRegistry.getHolder(key);
        return holder == null ? null : holder.value();
    }

    public @Nullable ChatChannel channelByValue(String value) {
        if (value.contains(":")) {
            return this.channel(Key.key((String)value));
        }
        for (Key key : this.keys()) {
            if (!key.value().equalsIgnoreCase(value)) continue;
            return this.channel(key);
        }
        return null;
    }

    @Override
    public @NonNull Set<Key> keys() {
        return Collections.unmodifiableSet(this.channelRegistry.keys());
    }

    @Override
    public ChatChannel defaultChannel() {
        return Objects.requireNonNull(this.channel(this.defaultKey));
    }

    @Override
    public Key defaultKey() {
        return this.defaultKey;
    }

    @Override
    public ChatChannel channelOrDefault(Key key) {
        @Nullable ChatChannel channel = this.channel(key);
        if (channel != null) {
            return channel;
        }
        return this.defaultChannel();
    }

    @Override
    public ChatChannel channelOrThrow(Key key) {
        @Nullable ChatChannel channel = this.channel(key);
        if (channel != null) {
            return channel;
        }
        throw new NoSuchElementException("No channel registered with key '" + key.asString() + "'");
    }

    @Override
    public void allKeys(Consumer<Key> action) {
        for (Key key : this.channelRegistry.keys()) {
            action.accept(key);
        }
        this.eventHandler.subscribe(CarbonChannelRegisterEvent.class, event -> {
            for (Key key : event.registered()) {
                action.accept(key);
            }
        });
    }

    @Override
    public ChannelPermissions permission(String permission) {
        return new ChannelPermissionsImpl(permission, this.carbonMessages);
    }

    private record SpecialHandler<T extends ConfigChatChannel>(Class<T> cls, Supplier<T> defaultSupplier) {
    }
}

