/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.channels;

import carbonchat.libs.com.google.inject.Inject;
import carbonchat.libs.net.kyori.moonshine.Moonshine;
import carbonchat.libs.net.kyori.moonshine.exception.scan.UnscannableMethodException;
import carbonchat.libs.net.kyori.moonshine.strategy.StandardPlaceholderResolverStrategy;
import carbonchat.libs.net.kyori.moonshine.strategy.supertype.StandardSupertypeThenInterfaceSupertypeStrategy;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.Nullable;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import carbonchat.libs.org.spongepowered.configurate.objectmapping.ConfigSerializable;
import carbonchat.libs.org.spongepowered.configurate.objectmapping.meta.Comment;
import carbonchat.libs.org.spongepowered.configurate.objectmapping.meta.Setting;
import io.leangen.geantyref.TypeToken;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.draycia.carbon.api.CarbonServer;
import net.draycia.carbon.api.channels.ChannelPermissions;
import net.draycia.carbon.api.channels.ChatChannel;
import net.draycia.carbon.api.users.CarbonPlayer;
import net.draycia.carbon.common.channels.ChannelPermissionsImpl;
import net.draycia.carbon.common.channels.messages.ConfigChannelMessageSource;
import net.draycia.carbon.common.channels.messages.ConfigChannelMessages;
import net.draycia.carbon.common.messages.CarbonMessageRenderer;
import net.draycia.carbon.common.messages.CarbonMessages;
import net.draycia.carbon.common.messages.SourcedAudience;
import net.draycia.carbon.common.messages.SourcedMessageSender;
import net.draycia.carbon.common.messages.SourcedReceiverResolver;
import net.draycia.carbon.common.messages.placeholders.BooleanPlaceholderResolver;
import net.draycia.carbon.common.messages.placeholders.ComponentPlaceholderResolver;
import net.draycia.carbon.common.messages.placeholders.IntPlaceholderResolver;
import net.draycia.carbon.common.messages.placeholders.KeyPlaceholderResolver;
import net.draycia.carbon.common.messages.placeholders.LongPlaceholderResolver;
import net.draycia.carbon.common.messages.placeholders.StringPlaceholderResolver;
import net.draycia.carbon.common.messages.placeholders.UUIDPlaceholderResolver;
import net.draycia.carbon.common.util.Exceptions;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;

@ConfigSerializable
@DefaultQualifier(value=NonNull.class)
public class ConfigChatChannel
implements ChatChannel {
    @Inject
    protected transient @MonotonicNonNull CarbonServer server;
    @Inject
    private transient @MonotonicNonNull CarbonMessageRenderer renderer;
    @Inject
    protected transient @MonotonicNonNull CarbonMessages messages;
    @Comment(value="The channel's key, used to track the channel.\nYou only need to change the second part of the key. \"global\" by default.\nThe value is what's used in commands, this is probably what you want to change.")
    protected @Nullable Key key = Key.key((String)"carbon", (String)"global");
    @Comment(value="The permission required to use the /channel <channelname> and /<channelname> commands.\n\nAssuming permission = \"carbon.channel.global\"\nTo read messages you must have the permission carbon.channel.global.see\nTo send messages you must have the permission carbon.channel.global.speak")
    private @Nullable String permission = null;
    @Setting(value="format")
    @Comment(value="The chat formats for this channel.")
    protected @Nullable ConfigChannelMessageSource messageSource = new ConfigChannelMessageSource();
    @Comment(value="Messages will be sent in this channel if they start with this prefix. (Leave empty/blank to disable quick prefix for this channel)")
    private @Nullable String quickPrefix = "";
    private @Nullable Boolean shouldRegisterCommands = true;
    private @Nullable String commandName = null;
    protected @Nullable List<String> commandAliases = Collections.emptyList();
    private transient @Nullable ConfigChannelMessages carbonMessages = null;
    @Comment(value="The distance players must be within to see each other's messages.\nA value of '0' requires that both players are in the same world.\nOn velocity, '0' requires that both players are in the same server.")
    private int radius = -1;
    @Comment(value="If true, players will be able to see if they're not sending messages to anyone\nbecause they're out of range from the radius.")
    private boolean emptyRadiusRecipientsMessage = true;
    private Map<UUID, Long> cooldowns = new HashMap<UUID, Long>();
    private long cooldown = -1L;
    @Comment(value="Whether this channel's messages should be sent cross-server.")
    private boolean crossServer = true;

    @Override
    public @Nullable String quickPrefix() {
        if (this.quickPrefix == null || this.quickPrefix.isBlank()) {
            return null;
        }
        return this.quickPrefix;
    }

    @Override
    public boolean shouldRegisterCommands() {
        return Objects.requireNonNullElse(this.shouldRegisterCommands, true);
    }

    @Override
    public String commandName() {
        return Objects.requireNonNullElse(this.commandName, this.key.value());
    }

    @Override
    public List<String> commandAliases() {
        return Objects.requireNonNullElse(this.commandAliases, Collections.emptyList());
    }

    @Override
    @NotNull
    public Component render(CarbonPlayer sender, Audience recipient, Component message, Component originalMessage) {
        return this.carbonMessages().chatFormat(SourcedAudience.of(sender, recipient), sender.uuid(), this.key(), sender.displayName(), sender.username(), message, (Component)Component.text((String)"null"));
    }

    @Override
    public ChannelPermissions permissions() {
        return new ChannelPermissionsImpl(this.permission(), this.messages);
    }

    @Override
    public List<Audience> recipients(CarbonPlayer sender) {
        ArrayList<Audience> recipients = new ArrayList<Audience>();
        for (CarbonPlayer carbonPlayer : this.server.players()) {
            if (!this.permissions().hearingPermitted(carbonPlayer).permitted() || carbonPlayer.leftChannels().contains(this.key)) continue;
            recipients.add(carbonPlayer);
        }
        recipients.add(this.server.console());
        return recipients;
    }

    @Override
    public long cooldown() {
        return this.cooldown * 1000L;
    }

    @Override
    public long playerCooldown(CarbonPlayer player) {
        if (this.cooldown() <= 0L) {
            return 0L;
        }
        return Objects.requireNonNullElse(this.cooldowns.get(player.uuid()), 0L);
    }

    @Override
    public long startCooldown(CarbonPlayer player) {
        long expiresAt = System.currentTimeMillis() + this.cooldown();
        return Objects.requireNonNullElse(this.cooldowns.put(player.uuid(), expiresAt), 0L);
    }

    public @NonNull Key key() {
        return Objects.requireNonNull(this.key);
    }

    public String messageFormat(CarbonPlayer sender) {
        return this.messageSource.messageOf(SourcedAudience.of(sender, sender), "");
    }

    private ConfigChannelMessages loadMessages() {
        SourcedReceiverResolver serverReceiverResolver = new SourcedReceiverResolver();
        ComponentPlaceholderResolver componentPlaceholderResolver = new ComponentPlaceholderResolver();
        UUIDPlaceholderResolver uuidPlaceholderResolver = new UUIDPlaceholderResolver();
        StringPlaceholderResolver stringPlaceholderResolver = new StringPlaceholderResolver();
        KeyPlaceholderResolver keyPlaceholderResolver = new KeyPlaceholderResolver();
        BooleanPlaceholderResolver booleanPlaceholderResolver = new BooleanPlaceholderResolver();
        SourcedMessageSender carbonMessageSender = new SourcedMessageSender();
        try {
            return Moonshine.builder(new TypeToken<ConfigChannelMessages>(this){}).receiverLocatorResolver(serverReceiverResolver, 0).sourced(this.messageSource).rendered(this.renderer.asSourced()).sent(carbonMessageSender).resolvingWithStrategy(new StandardPlaceholderResolverStrategy(new StandardSupertypeThenInterfaceSupertypeStrategy(false))).weightedPlaceholderResolver(Component.class, componentPlaceholderResolver, 0).weightedPlaceholderResolver(UUID.class, uuidPlaceholderResolver, 0).weightedPlaceholderResolver(String.class, stringPlaceholderResolver, 0).weightedPlaceholderResolver(Integer.class, new IntPlaceholderResolver(), 0).weightedPlaceholderResolver(Long.class, new LongPlaceholderResolver(), 0).weightedPlaceholderResolver(Key.class, keyPlaceholderResolver, 0).weightedPlaceholderResolver(Boolean.class, booleanPlaceholderResolver, 0).create(this.getClass().getClassLoader());
        }
        catch (UnscannableMethodException e) {
            throw Exceptions.rethrow(e);
        }
    }

    protected ConfigChannelMessages carbonMessages() {
        if (this.carbonMessages == null) {
            this.carbonMessages = this.loadMessages();
        }
        return Objects.requireNonNull(this.carbonMessages, "Channel message service must not be null!");
    }

    private String permission() {
        if (this.permission == null) {
            return "carbon.channel." + this.key().value();
        }
        return this.permission;
    }

    @Override
    public double radius() {
        return this.radius;
    }

    @Override
    public boolean emptyRadiusRecipientsMessage() {
        return this.emptyRadiusRecipientsMessage;
    }

    @Override
    public boolean shouldCrossServer() {
        return this.crossServer;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ConfigChatChannel)) {
            return false;
        }
        ConfigChatChannel otherChannel = (ConfigChatChannel)other;
        return otherChannel.key().equals((Object)this.key());
    }

    public int hashCode() {
        return Objects.hash(this.key());
    }
}

