/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.channels;

import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.Nullable;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import carbonchat.libs.org.spongepowered.configurate.objectmapping.ConfigSerializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.draycia.carbon.api.channels.ChannelPermissionResult;
import net.draycia.carbon.api.channels.ChannelPermissions;
import net.draycia.carbon.api.users.CarbonPlayer;
import net.draycia.carbon.api.users.Party;
import net.draycia.carbon.common.channels.ConfigChatChannel;
import net.draycia.carbon.common.channels.messages.ConfigChannelMessageSource;
import net.draycia.carbon.common.messages.SourcedAudience;
import net.draycia.carbon.common.users.WrappedCarbonPlayer;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;

@ConfigSerializable
@DefaultQualifier(value=NonNull.class)
public class PartyChatChannel
extends ConfigChatChannel {
    public static final String FILE_NAME = "partychat.conf";

    public PartyChatChannel() {
        this.key = Key.key((String)"carbon", (String)"partychat");
        this.commandAliases = List.of("pc");
        this.messageSource = new ConfigChannelMessageSource();
        this.messageSource.defaults = Map.of("default_format", "(party: <party_name>) <display_name>: <message>", "console", "[party: <party_name>] <username>: <message>");
    }

    @Override
    public ChannelPermissions permissions() {
        return ChannelPermissions.uniformDynamic(player -> ChannelPermissionResult.channelPermissionResult(player.party().join() != null, () -> this.messages.cannotUsePartyChannel((Audience)player)));
    }

    @Override
    public List<Audience> recipients(CarbonPlayer sender) {
        WrappedCarbonPlayer wrapped = (WrappedCarbonPlayer)sender;
        @Nullable UUID party = wrapped.partyId();
        if (party == null) {
            if (sender.online()) {
                sender.sendMessage(this.messages.cannotUsePartyChannel(sender));
            }
            return new ArrayList<Audience>();
        }
        List<Audience> recipients = super.recipients(sender);
        recipients.removeIf(r -> {
            WrappedCarbonPlayer p;
            return r instanceof WrappedCarbonPlayer && !Objects.equals((p = (WrappedCarbonPlayer)r).partyId(), party);
        });
        return recipients;
    }

    @Override
    @NotNull
    public Component render(CarbonPlayer sender, Audience recipient, Component message, Component originalMessage) {
        @Nullable Party party = sender.party().join();
        return this.carbonMessages().chatFormat(SourcedAudience.of(sender, recipient), sender.uuid(), this.key(), sender.displayName(), sender.username(), message, (Component)(party == null ? Component.text((String)"null") : party.name()));
    }
}

