/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.channels.messages;

import carbonchat.libs.net.kyori.moonshine.message.IMessageSource;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.Nullable;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import carbonchat.libs.org.spongepowered.configurate.objectmapping.ConfigSerializable;
import carbonchat.libs.org.spongepowered.configurate.objectmapping.meta.Comment;
import carbonchat.libs.org.spongepowered.configurate.objectmapping.meta.Setting;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import net.draycia.carbon.api.users.CarbonPlayer;
import net.draycia.carbon.common.messages.SourcedAudience;
import net.draycia.carbon.common.users.ConsoleCarbonPlayer;
import net.draycia.carbon.common.util.DiscordRecipient;
import net.kyori.adventure.audience.Audience;

@ConfigSerializable
@DefaultQualifier(value=NonNull.class)
public class ConfigChannelMessageSource
implements IMessageSource<SourcedAudience, String> {
    @Setting(value="basic")
    @Comment(value="Basic chat formats.\nThe \"default_format\" format is the main one you want to edit.\nThe \"console\" format is what's shown to console.\nThe \"discord\" format is what's shown to supported discord integrations.\nIf PlaceholderAPI is installed, PAPI placeholders (with %) are supported.\nIf MiniPlaceholders is installed, its placeholders (with <>) are supported.\nThe keys are group names, the values are chat formats (MiniMessage).\nFor example:\n    basic {\n        default_format=\"<<username>> <message>\"\n        vip=\"[VIP] <<username>> <message>\"\n        admin=\"<white>[</white>Prefix<white>]</white> <display_name><white>: <message></white>\"\n        discord=\"<message>\"\n    }\n")
    public Map<String, String> defaults = Map.of("default_format", "<display_name>: <message>", "console", "[<channel>] <username>: <message>", "discord", "<message>");
    @Comment(value="Per-Language chat formats.\nYou can safely leave this section empty if you don't want to use this feature.\nEach locale section can be configured in the same way as the above 'basic' section.\nWill fall back to the 'basic' section if no format was found for the player's locale.")
    public Map<Locale, Map<String, String>> locales = Map.of(Locale.getDefault(), Map.of());
    private static final String FALLBACK_FORMAT = "<red><</red><username><red>></red> <message>";

    @Override
    public String messageOf(SourcedAudience sourcedAudience, String ignored) {
        if (sourcedAudience.recipient() instanceof CarbonPlayer && !(sourcedAudience.recipient() instanceof ConsoleCarbonPlayer)) {
            return this.forPlayer(sourcedAudience);
        }
        if (sourcedAudience.recipient() instanceof DiscordRecipient) {
            return this.defaults.getOrDefault("discord", FALLBACK_FORMAT);
        }
        return this.defaults.getOrDefault("console", FALLBACK_FORMAT);
    }

    private String forPlayer(SourcedAudience sourcedAudience) {
        String format;
        Map<String, String> formats;
        CarbonPlayer sender = (CarbonPlayer)sourcedAudience.sender();
        CarbonPlayer recipient = (CarbonPlayer)sourcedAudience.recipient();
        if (recipient.locale() != null && (formats = this.locales.get(recipient.locale())) != null) {
            @Nullable String format2 = formats.get(sender.primaryGroup());
            if (format2 != null) {
                return format2;
            }
            for (String groupEntry : sender.groups()) {
                @Nullable String groupFormat = formats.get(groupEntry);
                if (groupFormat == null) continue;
                return groupFormat;
            }
        }
        if ((format = this.defaults.get(sender.primaryGroup())) != null) {
            return format;
        }
        for (String groupEntry : sender.groups()) {
            @Nullable String groupFormat = this.defaults.get(groupEntry);
            if (groupFormat == null) continue;
            return groupFormat;
        }
        return Objects.requireNonNullElse(this.defaults.get("default_format"), FALLBACK_FORMAT);
    }

    private String forAudience(Audience audience) {
        return Objects.requireNonNullElse(this.defaults.get("console"), FALLBACK_FORMAT);
    }
}

