/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.command;

import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.draycia.carbon.common.command.Commander;
import net.draycia.carbon.common.util.ConcurrentUtil;
import org.apache.logging.log4j.Logger;
import org.incendo.cloud.execution.ExecutionCoordinator;

@DefaultQualifier(value=NonNull.class)
public record ExecutionCoordinatorHolder(ExecutionCoordinator<Commander> executionCoordinator, ExecutorService executorService) {
    public void shutdown() {
        ConcurrentUtil.shutdownExecutor(this.executorService, TimeUnit.MILLISECONDS, 50L);
    }

    public static ExecutionCoordinatorHolder create(Logger logger) {
        ExecutorService executorService = Executors.newFixedThreadPool(4, ConcurrentUtil.carbonThreadFactory(logger, "Commands"));
        return new ExecutionCoordinatorHolder((ExecutionCoordinator<Commander>)ExecutionCoordinator.coordinatorFor((Executor)executorService), executorService);
    }
}

