/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.command.argument;

import carbonchat.libs.com.google.inject.Inject;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import io.leangen.geantyref.TypeToken;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.draycia.carbon.api.users.CarbonPlayer;
import net.draycia.carbon.api.users.UserManager;
import net.draycia.carbon.common.command.Commander;
import net.draycia.carbon.common.command.argument.PlayerSuggestions;
import net.draycia.carbon.common.command.exception.ComponentException;
import net.draycia.carbon.common.messages.CarbonMessages;
import net.draycia.carbon.common.users.ProfileResolver;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.context.CommandInput;
import org.incendo.cloud.parser.ArgumentParseResult;
import org.incendo.cloud.parser.ArgumentParser;
import org.incendo.cloud.parser.ParserDescriptor;
import org.incendo.cloud.suggestion.SuggestionProvider;

@DefaultQualifier(value=NonNull.class)
public final class CarbonPlayerParser
implements ArgumentParser.FutureArgumentParser<Commander, CarbonPlayer>,
ParserDescriptor<Commander, CarbonPlayer> {
    private final PlayerSuggestions suggestions;
    private final UserManager<?> userManager;
    private final ProfileResolver profileResolver;
    private final CarbonMessages messages;

    @Inject
    private CarbonPlayerParser(PlayerSuggestions suggestions, UserManager<?> userManager, ProfileResolver profileResolver, CarbonMessages messages) {
        this.suggestions = suggestions;
        this.userManager = userManager;
        this.profileResolver = profileResolver;
        this.messages = messages;
    }

    public CompletableFuture<ArgumentParseResult<CarbonPlayer>> parseFuture(CommandContext<Commander> commandContext, CommandInput commandInput) {
        String input = commandInput.readString();
        return this.profileResolver.resolveUUID(input, commandContext.isSuggestions()).thenCompose(uuid -> {
            if (uuid == null) {
                return ArgumentParseResult.failureFuture((Throwable)new ParseException(input, this.messages));
            }
            return this.userManager.user((UUID)uuid).thenApply(ArgumentParseResult::success);
        });
    }

    public @NonNull SuggestionProvider<Commander> suggestionProvider() {
        return this.suggestions;
    }

    public @NonNull TypeToken<CarbonPlayer> valueType() {
        return TypeToken.get(CarbonPlayer.class);
    }

    public @NonNull ArgumentParser<Commander, CarbonPlayer> parser() {
        return this;
    }

    public static final class ParseException
    extends ComponentException {
        private static final long serialVersionUID = -8331761537951077684L;
        private final String input;

        public ParseException(String input, CarbonMessages messages) {
            super(messages.errorCommandInvalidPlayer(input));
            this.input = input;
        }

        public String input() {
            return this.input;
        }
    }
}

