/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.command.commands;

import carbonchat.libs.com.google.inject.Inject;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import carbonchat.libs.org.incendo.cloud.minecraft.extras.RichDescription;
import net.draycia.carbon.api.CarbonServer;
import net.draycia.carbon.api.users.CarbonPlayer;
import net.draycia.carbon.common.command.CarbonCommand;
import net.draycia.carbon.common.command.CommandSettings;
import net.draycia.carbon.common.command.Commander;
import net.draycia.carbon.common.command.PlayerCommander;
import net.draycia.carbon.common.config.ConfigManager;
import net.draycia.carbon.common.messages.CarbonMessages;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import org.incendo.cloud.Command;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.description.Description;

@DefaultQualifier(value=NonNull.class)
public final class ClearChatCommand
extends CarbonCommand {
    private final CarbonServer server;
    private final CommandManager<Commander> commandManager;
    private final ConfigManager configManager;
    private final CarbonMessages carbonMessages;

    @Inject
    public ClearChatCommand(CarbonServer server, CommandManager<Commander> commandManager, ConfigManager configManager, CarbonMessages carbonMessages) {
        this.server = server;
        this.commandManager = commandManager;
        this.configManager = configManager;
        this.carbonMessages = carbonMessages;
    }

    @Override
    public CommandSettings defaultCommandSettings() {
        return new CommandSettings("clearchat", "chatclear", "cc");
    }

    @Override
    public Key key() {
        return Key.key((String)"carbon", (String)"clearchat");
    }

    @Override
    public void init() {
        Command command = this.commandManager.commandBuilder(this.commandSettings().name(), this.commandSettings().aliases()).permission("carbon.clearchat.clear").commandDescription((Description)RichDescription.richDescription((ComponentLike)this.carbonMessages.commandClearChatDescription())).handler(handler -> {
            String username;
            TextComponent senderName;
            for (int i = 0; i < this.configManager.primaryConfig().clearChatSettings().iterations(); ++i) {
                for (CarbonPlayer carbonPlayer : this.server.players()) {
                    if (carbonPlayer.hasPermission("carbon.clearchat.exempt")) continue;
                    carbonPlayer.sendMessage(this.configManager.primaryConfig().clearChatSettings().message());
                }
            }
            Object patt0$temp = handler.sender();
            if (patt0$temp instanceof PlayerCommander) {
                PlayerCommander playerCommander = (PlayerCommander)patt0$temp;
                senderName = playerCommander.carbonPlayer().displayName();
                username = playerCommander.carbonPlayer().username();
            } else {
                senderName = Component.text((String)"Console");
                username = "Console";
            }
            this.server.sendMessage(this.configManager.primaryConfig().clearChatSettings().broadcast((Component)senderName, username));
        }).build();
        this.commandManager.command(command);
    }
}

