/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.command.commands;

import carbonchat.libs.com.google.inject.Inject;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import carbonchat.libs.org.incendo.cloud.minecraft.extras.RichDescription;
import java.util.ArrayList;
import net.draycia.carbon.api.users.CarbonPlayer;
import net.draycia.carbon.common.command.CarbonCommand;
import net.draycia.carbon.common.command.CommandSettings;
import net.draycia.carbon.common.command.Commander;
import net.draycia.carbon.common.command.ParserFactory;
import net.draycia.carbon.common.command.PlayerCommander;
import net.draycia.carbon.common.messages.CarbonMessages;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.incendo.cloud.Command;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.description.Description;
import org.incendo.cloud.parser.ParserDescriptor;

@DefaultQualifier(value=NonNull.class)
public final class DebugCommand
extends CarbonCommand {
    private final CommandManager<Commander> commandManager;
    private final CarbonMessages carbonMessages;
    private final ParserFactory parserFactory;

    @Inject
    public DebugCommand(CommandManager<Commander> commandManager, CarbonMessages carbonMessages, ParserFactory parserFactory) {
        this.commandManager = commandManager;
        this.carbonMessages = carbonMessages;
        this.parserFactory = parserFactory;
    }

    @Override
    public CommandSettings defaultCommandSettings() {
        return new CommandSettings("carbondebug", "cdebug");
    }

    @Override
    public Key key() {
        return Key.key((String)"carbon", (String)"debug");
    }

    @Override
    public void init() {
        Command command = this.commandManager.commandBuilder(this.commandSettings().name(), this.commandSettings().aliases()).optional("player", (ParserDescriptor)this.parserFactory.carbonPlayer(), (Description)RichDescription.richDescription((ComponentLike)this.carbonMessages.commandDebugArgumentPlayer())).permission("carbon.debug").senderType(Commander.class).commandDescription((Description)RichDescription.richDescription((ComponentLike)this.carbonMessages.commandDebugDescription())).handler(handler -> {
            CarbonPlayer target;
            Commander sender = (Commander)handler.sender();
            if (handler.contains("player")) {
                target = (CarbonPlayer)handler.get("player");
            } else if (sender instanceof PlayerCommander) {
                PlayerCommander playerCommander = (PlayerCommander)sender;
                target = playerCommander.carbonPlayer();
            } else {
                return;
            }
            sender.sendMessage(Component.join((JoinConfiguration)JoinConfiguration.noSeparators(), (ComponentLike[])new ComponentLike[]{Component.text((String)"Primary Group: ", (TextColor)NamedTextColor.GOLD), Component.text((String)target.primaryGroup(), (TextColor)NamedTextColor.GREEN)}));
            ArrayList<TextComponent> groups = new ArrayList<TextComponent>();
            for (String group : target.groups()) {
                groups.add(Component.text((String)group, (TextColor)NamedTextColor.GREEN));
            }
            Component formattedGroupsList = Component.join((JoinConfiguration)JoinConfiguration.separator((ComponentLike)Component.text((String)", ", (TextColor)NamedTextColor.YELLOW)), groups);
            sender.sendMessage(Component.join((JoinConfiguration)JoinConfiguration.noSeparators(), (ComponentLike[])new ComponentLike[]{Component.text((String)"Groups: ", (TextColor)NamedTextColor.GOLD), formattedGroupsList}));
        }).build();
        this.commandManager.command(command);
    }
}

