/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.command.commands;

import carbonchat.libs.com.google.inject.Inject;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import carbonchat.libs.org.incendo.cloud.minecraft.extras.RichDescription;
import net.draycia.carbon.api.users.CarbonPlayer;
import net.draycia.carbon.common.command.CarbonCommand;
import net.draycia.carbon.common.command.CommandSettings;
import net.draycia.carbon.common.command.Commander;
import net.draycia.carbon.common.command.PlayerCommander;
import net.draycia.carbon.common.messages.CarbonMessages;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.ComponentLike;
import org.incendo.cloud.Command;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.description.Description;
import org.incendo.cloud.parser.standard.BooleanParser;

@DefaultQualifier(value=NonNull.class)
public final class FilterCommand
extends CarbonCommand {
    private final CommandManager<Commander> commandManager;
    private final CarbonMessages carbonMessages;

    @Inject
    public FilterCommand(CommandManager<Commander> commandManager, CarbonMessages carbonMessages) {
        this.commandManager = commandManager;
        this.carbonMessages = carbonMessages;
    }

    @Override
    public CommandSettings defaultCommandSettings() {
        return new CommandSettings("filter", new String[0]);
    }

    @Override
    public Key key() {
        return Key.key((String)"carbon", (String)"filter");
    }

    @Override
    public void init() {
        Command command = this.commandManager.commandBuilder(this.commandSettings().name(), this.commandSettings().aliases()).optional("enabled", BooleanParser.booleanParser()).permission("carbon.filter").senderType(PlayerCommander.class).commandDescription((Description)RichDescription.richDescription((ComponentLike)this.carbonMessages.commandOptionalFilterDescription())).handler(handler -> {
            boolean enabled;
            CarbonPlayer sender = ((PlayerCommander)handler.sender()).carbonPlayer();
            boolean bl = enabled = !sender.spying();
            if (handler.contains("enabled")) {
                enabled = (Boolean)handler.get("enabled");
            }
            sender.applyOptionalChatFilters(enabled);
            if (enabled) {
                this.carbonMessages.commandOptionalFilterEnabled(sender);
            } else {
                this.carbonMessages.commandOptionalFilterDisabled(sender);
            }
        }).build();
        this.commandManager.command(command);
    }
}

